/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public interface RestTemplateSpanDecorator {
    public void onRequest(HttpRequest var1, Span var2);

    public void onResponse(HttpRequest var1, ClientHttpResponse var2, Span var3);

    public void onError(HttpRequest var1, Throwable var2, Span var3);

    public static class StandardTags
    implements RestTemplateSpanDecorator {
        private static final Log log = LogFactory.getLog(StandardTags.class);
        public static final String COMPONENT_NAME = "java-spring-rest-template";

        @Override
        public void onRequest(HttpRequest request, Span span) {
            Tags.COMPONENT.set(span, COMPONENT_NAME);
            Tags.HTTP_URL.set(span, request.getURI().toString());
            Tags.HTTP_METHOD.set(span, request.getMethod().toString());
            if (request.getURI().getPort() != -1) {
                Tags.PEER_PORT.set(span, Integer.valueOf(request.getURI().getPort()));
            }
        }

        @Override
        public void onResponse(HttpRequest httpRequest, ClientHttpResponse response, Span span) {
            try {
                Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getRawStatusCode()));
            }
            catch (IOException e) {
                log.error((Object)"Could not get HTTP status code");
            }
        }

        @Override
        public void onError(HttpRequest httpRequest, Throwable ex, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(StandardTags.errorLogs(ex));
        }

        public static Map<String, Object> errorLogs(Throwable ex) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", ex);
            return errorLogs;
        }
    }
}

