/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.autoconfig;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.TracingRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateAutoConfiguration {
    @Autowired(required=false)
    private Set<RestTemplate> restTemplates;
    @Autowired
    private Tracer tracer;

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (RestTemplate restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }
    }

    private void registerTracingInterceptor(RestTemplate restTemplate) {
        ArrayList<TracingRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
        for (ClientHttpRequestInterceptor clientHttpRequestInterceptor : interceptors) {
            if (!(clientHttpRequestInterceptor instanceof TracingRestTemplateInterceptor)) continue;
            return;
        }
        interceptors = new ArrayList<TracingRestTemplateInterceptor>(interceptors);
        interceptors.add(new TracingRestTemplateInterceptor(this.tracer));
        restTemplate.setInterceptors(interceptors);
    }
}

