/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.autoconfig;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.TracingAsyncRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
public class AsyncRestTemplateAutoConfiguration {
    @Autowired(required=false)
    private Set<AsyncRestTemplate> restTemplates;
    @Autowired
    private Tracer tracer;

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (AsyncRestTemplate restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }
    }

    private void registerTracingInterceptor(AsyncRestTemplate restTemplate) {
        ArrayList<TracingAsyncRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
        for (AsyncClientHttpRequestInterceptor asyncClientHttpRequestInterceptor : interceptors) {
            if (!(asyncClientHttpRequestInterceptor instanceof TracingAsyncRestTemplateInterceptor)) continue;
            return;
        }
        interceptors = new ArrayList<TracingAsyncRestTemplateInterceptor>(interceptors);
        interceptors.add(new TracingAsyncRestTemplateInterceptor(this.tracer));
        restTemplate.setInterceptors(interceptors);
    }
}

