/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import feign.opentracing.FeignSpanDecorator;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.feign.TraceFeignContext;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.openfeign.FeignContext;

public class FeignContextBeanPostProcessor
implements BeanPostProcessor {
    private Tracer tracer;
    private BeanFactory beanFactory;
    private List<FeignSpanDecorator> spanDecorators;

    FeignContextBeanPostProcessor(Tracer tracer, BeanFactory beanFactory, List<FeignSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.beanFactory = beanFactory;
        this.spanDecorators = spanDecorators;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        if (bean instanceof FeignContext && !(bean instanceof TraceFeignContext)) {
            return new TraceFeignContext(this.tracer, (FeignContext)bean, this.beanFactory, this.spanDecorators);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        return bean;
    }
}

