/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AggregationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Base2ExponentialBucketHistogramAggregationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExplicitBucketHistogramAggregationModel;
import io.opentelemetry.sdk.metrics.Aggregation;
import java.util.List;

final class AggregationFactory
implements Factory<AggregationModel, Aggregation> {
    private static final AggregationFactory INSTANCE = new AggregationFactory();

    private AggregationFactory() {
    }

    static AggregationFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Aggregation create(AggregationModel model, DeclarativeConfigContext context) {
        if (model.getDrop() != null) {
            return Aggregation.drop();
        }
        if (model.getSum() != null) {
            return Aggregation.sum();
        }
        if (model.getLastValue() != null) {
            return Aggregation.lastValue();
        }
        Base2ExponentialBucketHistogramAggregationModel exponentialBucketHistogram = model.getBase2ExponentialBucketHistogram();
        if (exponentialBucketHistogram != null) {
            Integer maxSize;
            Integer maxScale = exponentialBucketHistogram.getMaxScale();
            if (maxScale == null) {
                maxScale = 20;
            }
            if ((maxSize = exponentialBucketHistogram.getMaxSize()) == null) {
                maxSize = 160;
            }
            try {
                return Aggregation.base2ExponentialBucketHistogram((int)maxSize, (int)maxScale);
            }
            catch (IllegalArgumentException e) {
                throw new DeclarativeConfigException("Invalid exponential bucket histogram", (Throwable)e);
            }
        }
        ExplicitBucketHistogramAggregationModel explicitBucketHistogram = model.getExplicitBucketHistogram();
        if (explicitBucketHistogram != null) {
            List<Double> boundaries = explicitBucketHistogram.getBoundaries();
            if (boundaries == null) {
                return Aggregation.explicitBucketHistogram();
            }
            try {
                return Aggregation.explicitBucketHistogram(boundaries);
            }
            catch (IllegalArgumentException e) {
                throw new DeclarativeConfigException("Invalid explicit bucket histogram", (Throwable)e);
            }
        }
        return Aggregation.defaultAggregation();
    }
}

