/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.OpenTelemetryConfigurationFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.YamlStructuredConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.constructor.BaseConstructor;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.schema.CoreSchema;
import org.snakeyaml.engine.v2.schema.Schema;

public final class FileConfiguration {
    private static final Logger logger = Logger.getLogger(FileConfiguration.class.getName());
    private static final Pattern ENV_VARIABLE_REFERENCE = Pattern.compile("\\$\\{([a-zA-Z_][a-zA-Z0-9_]*)}");
    private static final ObjectMapper MAPPER = new ObjectMapper().setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));

    private FileConfiguration() {
    }

    public static OpenTelemetrySdk parseAndCreate(InputStream inputStream) {
        OpenTelemetryConfiguration configurationModel = FileConfiguration.parse(inputStream);
        return FileConfiguration.create(configurationModel);
    }

    public static OpenTelemetrySdk create(OpenTelemetryConfiguration configurationModel) {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            return OpenTelemetryConfigurationFactory.getInstance().create(configurationModel, SpiHelper.create((ClassLoader)FileConfiguration.class.getClassLoader()), (List<Closeable>)closeables);
        }
        catch (RuntimeException e) {
            logger.info("Error encountered interpreting configuration model. Closing partially configured components.");
            for (Closeable closeable : closeables) {
                try {
                    logger.fine("Closing " + closeable.getClass().getName());
                    closeable.close();
                }
                catch (IOException ex) {
                    logger.warning("Error closing " + closeable.getClass().getName() + ": " + ex.getMessage());
                }
            }
            if (e instanceof ConfigurationException) {
                throw e;
            }
            throw new ConfigurationException("Unexpected configuration error", (Throwable)e);
        }
    }

    public static OpenTelemetryConfiguration parse(InputStream configuration) {
        try {
            return FileConfiguration.parse(configuration, System.getenv());
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Unable to parse configuration input stream", (Throwable)e);
        }
    }

    static OpenTelemetryConfiguration parse(InputStream configuration, Map<String, String> environmentVariables) {
        Object yamlObj = FileConfiguration.loadYaml(configuration, environmentVariables);
        return (OpenTelemetryConfiguration)MAPPER.convertValue(yamlObj, OpenTelemetryConfiguration.class);
    }

    static Object loadYaml(InputStream inputStream, Map<String, String> environmentVariables) {
        LoadSettings settings = LoadSettings.builder().setSchema((Schema)new CoreSchema()).build();
        Load yaml = new Load(settings, (BaseConstructor)new EnvSubstitutionConstructor(settings, environmentVariables));
        return yaml.loadFromInputStream(inputStream);
    }

    public static StructuredConfigProperties toConfigProperties(OpenTelemetryConfiguration model) {
        return FileConfiguration.toConfigProperties((Object)model);
    }

    static StructuredConfigProperties toConfigProperties(Object model) {
        Map configurationMap = (Map)MAPPER.convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return YamlStructuredConfigProperties.create(configurationMap);
    }

    static {
        MAPPER.configOverride(String.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Integer.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Double.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Boolean.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
    }

    private static final class EnvSubstitutionConstructor
    extends StandardConstructor {
        private final Load load;
        private final Map<String, String> environmentVariables;

        private EnvSubstitutionConstructor(LoadSettings loadSettings, Map<String, String> environmentVariables) {
            super(loadSettings);
            this.load = new Load(loadSettings);
            this.environmentVariables = environmentVariables;
        }

        protected Map<Object, Object> constructMapping(MappingNode node) {
            Map mapping = (Map)this.settings.getDefaultMap().apply(node.getValue().size());
            List nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                Node keyNode = tuple.getKeyNode();
                Object key = this.constructObject(keyNode);
                if (key != null) {
                    try {
                        key.hashCode();
                    }
                    catch (Exception e) {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), (Throwable)e);
                    }
                }
                Node valueNode = tuple.getValueNode();
                Object value = this.constructValueObject(valueNode);
                if (keyNode.isRecursive()) {
                    if (this.settings.getAllowRecursiveKeys()) {
                        this.postponeMapFilling(mapping, key, value);
                        continue;
                    }
                    throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
                }
                mapping.put(key, value);
            }
            return mapping;
        }

        private Object constructValueObject(Node node) {
            Object value = this.constructObject(node);
            if (!(node instanceof ScalarNode)) {
                return value;
            }
            if (!(value instanceof String)) {
                return value;
            }
            String val = (String)value;
            Matcher matcher = ENV_VARIABLE_REFERENCE.matcher(val);
            if (!matcher.find()) {
                return value;
            }
            int offset = 0;
            StringBuilder newVal = new StringBuilder();
            ScalarStyle scalarStyle = ((ScalarNode)node).getScalarStyle();
            do {
                MatchResult matchResult = matcher.toMatchResult();
                String replacement = this.environmentVariables.getOrDefault(matcher.group(1), "");
                newVal.append(val, offset, matchResult.start()).append(replacement);
                offset = matchResult.end();
            } while (matcher.find());
            if (offset != val.length()) {
                newVal.append(val, offset, val.length());
            }
            if (scalarStyle == ScalarStyle.DOUBLE_QUOTED) {
                newVal.insert(0, "\"");
                newVal.append("\"");
            }
            return this.load.loadFromString(newVal.toString());
        }
    }
}

