/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfiguration;
import java.io.Closeable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class FileConfigUtil {
    private FileConfigUtil() {
    }

    static <T> T addAndReturn(List<Closeable> closeables, T closeable) {
        if (closeable instanceof Closeable) {
            closeables.add((Closeable)closeable);
        }
        return closeable;
    }

    static <T> T assertNotNull(@Nullable T object, String description) {
        if (object == null) {
            throw new NullPointerException(description + " is null");
        }
        return object;
    }

    static <T> T loadComponent(SpiHelper spiHelper, Class<T> type, String name, Object model) {
        List componentProviders = spiHelper.load(ComponentProvider.class);
        List matchedProviders = componentProviders.stream().map(componentProvider -> componentProvider).filter(componentProvider -> componentProvider.getType() == type && name.equals(componentProvider.getName())).collect(Collectors.toList());
        if (matchedProviders.isEmpty()) {
            throw new ConfigurationException("No component provider detected for " + type.getName() + " with name \"" + name + "\".");
        }
        if (matchedProviders.size() > 1) {
            throw new ConfigurationException("Component provider conflict. Multiple providers detected for " + type.getName() + " with name \"" + name + "\": " + componentProviders.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(",", "[", "]")));
        }
        ComponentProvider provider2 = (ComponentProvider)matchedProviders.get(0);
        StructuredConfigProperties config = FileConfiguration.toConfigProperties(model);
        try {
            return (T)provider2.create(config);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException("Error configuring " + type.getName() + " with name \"" + name + "\"", throwable);
        }
    }
}

