/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Attributes;
import java.io.Closeable;
import java.util.List;
import javax.annotation.Nullable;

final class AttributesFactory
implements Factory<Attributes, io.opentelemetry.api.common.Attributes> {
    private static final AttributesFactory INSTANCE = new AttributesFactory();

    private AttributesFactory() {
    }

    static AttributesFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.api.common.Attributes create(@Nullable Attributes model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.api.common.Attributes.empty();
        }
        AttributesBuilder builder = io.opentelemetry.api.common.Attributes.builder();
        String serviceName = model.getServiceName();
        if (serviceName != null) {
            builder.put(AttributeKey.stringKey((String)"service.name"), (Object)serviceName);
        }
        model.getAdditionalProperties().forEach((key, value) -> {
            if (value == null) {
                throw new ConfigurationException("Error processing attribute with key \"" + key + "\": unexpected null value");
            }
            if (value instanceof String) {
                builder.put(key, (String)value);
                return;
            }
            if (value instanceof Integer) {
                builder.put(key, (long)((Integer)value).intValue());
                return;
            }
            if (value instanceof Long) {
                builder.put(key, ((Long)value).longValue());
                return;
            }
            if (value instanceof Double) {
                builder.put(key, ((Double)value).doubleValue());
                return;
            }
            if (value instanceof Float) {
                builder.put(key, (double)((Float)value).floatValue());
                return;
            }
            if (value instanceof Boolean) {
                builder.put(key, ((Boolean)value).booleanValue());
                return;
            }
            if (value instanceof List) {
                List values = (List)value;
                if (values.isEmpty()) {
                    return;
                }
                Object first = values.get(0);
                if (first instanceof String) {
                    AttributesFactory.checkAllEntriesOfType(key, values, String.class);
                    builder.put(AttributeKey.stringArrayKey((String)key), (Object[])((String[])values.stream().map(obj -> (String)obj).toArray(String[]::new)));
                    return;
                }
                if (first instanceof Long) {
                    AttributesFactory.checkAllEntriesOfType(key, values, Long.class);
                    builder.put(AttributeKey.longArrayKey((String)key), (Object[])((Long[])values.stream().map(obj -> (long)((Long)obj)).toArray(Long[]::new)));
                    return;
                }
                if (first instanceof Integer) {
                    AttributesFactory.checkAllEntriesOfType(key, values, Integer.class);
                    builder.put(AttributeKey.longArrayKey((String)key), (Object[])((Long[])values.stream().map(obj -> (long)((Integer)obj)).toArray(Long[]::new)));
                    return;
                }
                if (first instanceof Double) {
                    AttributesFactory.checkAllEntriesOfType(key, values, Double.class);
                    builder.put(AttributeKey.doubleArrayKey((String)key), (Object[])((Double[])values.stream().map(obj -> (double)((Double)obj)).toArray(Double[]::new)));
                    return;
                }
                if (first instanceof Float) {
                    AttributesFactory.checkAllEntriesOfType(key, values, Float.class);
                    builder.put(AttributeKey.doubleArrayKey((String)key), (Object[])((Double[])values.stream().map(obj -> ((Float)obj).floatValue()).toArray(Double[]::new)));
                    return;
                }
                if (first instanceof Boolean) {
                    AttributesFactory.checkAllEntriesOfType(key, values, Boolean.class);
                    builder.put(AttributeKey.booleanArrayKey((String)key), (Object[])((Boolean[])values.stream().map(obj -> (Boolean)obj).toArray(Boolean[]::new)));
                    return;
                }
            }
            throw new ConfigurationException("Error processing attribute with key \"" + key + "\": unrecognized value type " + value.getClass().getName());
        });
        return builder.build();
    }

    private static void checkAllEntriesOfType(String key, List<?> values, Class<?> expectedType) {
        values.forEach(value -> {
            if (value == null) {
                throw new ConfigurationException("Error processing attribute with key \"" + key + "\": unexpected null element in value");
            }
            if (!expectedType.isAssignableFrom(value.getClass())) {
                throw new ConfigurationException("Error processing attribute with key \"" + key + "\": expected value entries to be of type " + expectedType + " but found entry with type " + value.getClass());
            }
        });
    }
}

