/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v2_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;

final class ApacheHttpClientHttpAttributesGetter
implements HttpClientAttributesGetter<HttpMethod, HttpMethod> {
    ApacheHttpClientHttpAttributesGetter() {
    }

    public String getHttpRequestMethod(HttpMethod request) {
        return request.getName();
    }

    public String getUrlFull(HttpMethod request) {
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        if (hostConfiguration == null || hostConfiguration.getProtocol() == null) {
            String queryString = request.getQueryString();
            if (queryString == null) {
                return request.getPath();
            }
            return request.getPath() + "?" + request.getQueryString();
        }
        StringBuilder url = new StringBuilder();
        url.append(hostConfiguration.getProtocol().getScheme());
        url.append("://");
        url.append(hostConfiguration.getHost());
        int port = hostConfiguration.getPort();
        if (port != hostConfiguration.getProtocol().getDefaultPort()) {
            url.append(":");
            url.append(port);
        }
        url.append(request.getPath());
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append("?");
            url.append(request.getQueryString());
        }
        return url.toString();
    }

    public List<String> getHttpRequestHeader(HttpMethod request, String name) {
        Header header = request.getRequestHeader(name);
        return header == null ? Collections.emptyList() : Collections.singletonList(header.getValue());
    }

    @Nullable
    public Integer getHttpResponseStatusCode(HttpMethod request, HttpMethod response, @Nullable Throwable error) {
        StatusLine statusLine = response.getStatusLine();
        return statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode());
    }

    public List<String> getHttpResponseHeader(HttpMethod request, HttpMethod response, String name) {
        Header header = response.getResponseHeader(name);
        return header == null ? Collections.emptyList() : Collections.singletonList(header.getValue());
    }

    public String getNetworkProtocolName(HttpMethod request, @Nullable HttpMethod response) {
        return "http";
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpMethod request, @Nullable HttpMethod response) {
        if (request instanceof HttpMethodBase) {
            return ((HttpMethodBase)request).isHttp11() ? "1.1" : "1.0";
        }
        return null;
    }

    @Nullable
    public String getServerAddress(HttpMethod request) {
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        return hostConfiguration != null ? hostConfiguration.getHost() : null;
    }

    @Nullable
    public Integer getServerPort(HttpMethod request) {
        HostConfiguration hostConfiguration = request.getHostConfiguration();
        return hostConfiguration != null ? Integer.valueOf(hostConfiguration.getPort()) : null;
    }
}

