/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.lettuce.v5_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.OtelCommandArgsUtil;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.db.RedisCommandSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.lettuce.common.LettuceArgSplitter;
import io.opentelemetry.instrumentation.lettuce.v5_1.LettuceNetworkAttributesGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class OpenTelemetryTracing
implements Tracing {
    private static final AttributesExtractor<OpenTelemetryEndpoint, Void> serverAttributesExtractor = ServerAttributesExtractor.create((ServerAttributesGetter)new LettuceNetworkAttributesGetter());
    private final TracerProvider tracerProvider;

    OpenTelemetryTracing(io.opentelemetry.api.trace.Tracer tracer, RedisCommandSanitizer sanitizer) {
        this.tracerProvider = new OpenTelemetryTracerProvider(tracer, sanitizer);
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public TraceContextProvider initialTraceContextProvider() {
        return new OpenTelemetryTraceContextProvider();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean includeCommandArgsInSpanTags() {
        return true;
    }

    @Nullable
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return new OpenTelemetryEndpoint((InetSocketAddress)socketAddress);
        }
        return null;
    }

    private static class OpenTelemetryTracerProvider
    implements TracerProvider {
        private final Tracer openTelemetryTracer;

        OpenTelemetryTracerProvider(io.opentelemetry.api.trace.Tracer tracer, RedisCommandSanitizer sanitizer) {
            this.openTelemetryTracer = new OpenTelemetryTracer(tracer, sanitizer);
        }

        public Tracer getTracer() {
            return this.openTelemetryTracer;
        }
    }

    private static class OpenTelemetryTraceContextProvider
    implements TraceContextProvider {
        private OpenTelemetryTraceContextProvider() {
        }

        public TraceContext getTraceContext() {
            return new OpenTelemetryTraceContext();
        }
    }

    static class OpenTelemetryEndpoint
    implements Tracing.Endpoint {
        @Nullable
        final InetSocketAddress address;

        OpenTelemetryEndpoint(@Nullable InetSocketAddress address) {
            this.address = address;
        }
    }

    private static class OpenTelemetrySpan
    extends Tracer.Span {
        private final Context context;
        private final SpanBuilder spanBuilder;
        private final RedisCommandSanitizer sanitizer;
        @Nullable
        private String name;
        @Nullable
        private List<Object> events;
        @Nullable
        private Throwable error;
        @Nullable
        private Span span;
        @Nullable
        private List<String> argsList;
        @Nullable
        private String argsString;

        OpenTelemetrySpan(Context context, SpanBuilder spanBuilder, RedisCommandSanitizer sanitizer) {
            this.context = context;
            this.spanBuilder = spanBuilder;
            this.sanitizer = sanitizer;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span name(String name) {
            if (this.span != null) {
                this.span.updateName(name);
            }
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            if (endpoint instanceof OpenTelemetryEndpoint) {
                this.fillEndpoint((OpenTelemetryEndpoint)endpoint);
            }
            return this;
        }

        private void fillEndpoint(OpenTelemetryEndpoint endpoint) {
            AttributesBuilder attributesBuilder = Attributes.builder();
            Context currentContext = this.span == null ? this.context : this.context.with((ImplicitContextKeyed)this.span);
            serverAttributesExtractor.onEnd(attributesBuilder, currentContext, (Object)endpoint, null, null);
            if (this.span != null) {
                this.span.setAllAttributes(attributesBuilder.build());
            } else {
                this.spanBuilder.setAllAttributes(attributesBuilder.build());
            }
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span start(RedisCommand<?, ?, ?> command) {
            this.start();
            Span span = this.span;
            if (span == null) {
                throw new IllegalStateException("Span started but null, this is a programming error.");
            }
            span.updateName(command.getType().name());
            if (command.getArgs() != null) {
                this.argsList = OtelCommandArgsUtil.getCommandArgs(command.getArgs());
            }
            if (command instanceof CompleteableCommand) {
                CompleteableCommand completeableCommand = (CompleteableCommand)command;
                completeableCommand.onComplete((o, throwable) -> {
                    String error;
                    CommandOutput output;
                    if (throwable != null) {
                        span.recordException(throwable);
                    }
                    if ((output = command.getOutput()) != null && (error = output.getError()) != null) {
                        span.setStatus(StatusCode.ERROR, error);
                    }
                    this.finish(span);
                });
            }
            return this;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span start() {
            this.span = this.spanBuilder.startSpan();
            if (this.name != null) {
                this.span.updateName(this.name);
            }
            if (this.events != null) {
                for (int i = 0; i < this.events.size(); i += 2) {
                    this.span.addEvent((String)this.events.get(i), (Instant)this.events.get(i + 1));
                }
                this.events = null;
            }
            if (this.error != null) {
                this.span.setStatus(StatusCode.ERROR);
                this.span.recordException(this.error);
                this.error = null;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span annotate(String value) {
            if (this.span != null) {
                this.span.addEvent(value);
            } else {
                if (this.events == null) {
                    this.events = new ArrayList<Object>();
                }
                this.events.add(value);
                this.events.add(Instant.now());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span tag(String key, String value) {
            if (key.equals("redis.args")) {
                this.argsString = value;
                return this;
            }
            if (this.span != null) {
                this.span.setAttribute(key, value);
            } else {
                this.spanBuilder.setAttribute(key, value);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public synchronized Tracer.Span error(Throwable throwable) {
            if (this.span != null) {
                this.span.recordException(throwable);
            } else {
                this.error = throwable;
            }
            return this;
        }

        public synchronized void finish() {
            if (this.span != null) {
                this.finish(this.span);
            }
        }

        private void finish(Span span) {
            if (this.name != null) {
                String statement = this.sanitizer.sanitize(this.name, this.argsList != null ? this.argsList : LettuceArgSplitter.splitArgs((String)this.argsString));
                span.setAttribute(SemanticAttributes.DB_STATEMENT, (Object)statement);
            }
            span.end();
        }
    }

    private static class OpenTelemetryTracer
    extends Tracer {
        private final io.opentelemetry.api.trace.Tracer tracer;
        private final RedisCommandSanitizer sanitizer;

        OpenTelemetryTracer(io.opentelemetry.api.trace.Tracer tracer, RedisCommandSanitizer sanitizer) {
            this.tracer = tracer;
            this.sanitizer = sanitizer;
        }

        public OpenTelemetrySpan nextSpan() {
            return this.nextSpan(Context.current());
        }

        public OpenTelemetrySpan nextSpan(TraceContext traceContext) {
            if (!(traceContext instanceof OpenTelemetryTraceContext)) {
                return this.nextSpan();
            }
            Context context = ((OpenTelemetryTraceContext)traceContext).getSpanContext();
            return this.nextSpan(context);
        }

        private OpenTelemetrySpan nextSpan(Context context) {
            SpanBuilder spanBuilder = this.tracer.spanBuilder("redis").setSpanKind(SpanKind.CLIENT).setParent(context).setAttribute(SemanticAttributes.DB_SYSTEM, (Object)"redis");
            return new OpenTelemetrySpan(context, spanBuilder, this.sanitizer);
        }
    }

    private static class OpenTelemetryTraceContext
    implements TraceContext {
        private final Context context = Context.current();

        OpenTelemetryTraceContext() {
        }

        public Context getSpanContext() {
            return this.context;
        }
    }
}

