/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.protocol.CommandArgs;
import java.util.ArrayList;
import java.util.List;

public final class OtelCommandArgsUtil {
    public static List<String> getCommandArgs(CommandArgs<?, ?> commandArgs) {
        ArrayList<String> result = new ArrayList<String>();
        StringCodec stringCodec = new StringCodec();
        for (CommandArgs.SingularArgument argument : commandArgs.singularArguments) {
            String value = OtelCommandArgsUtil.getArgValue(stringCodec, argument);
            result.add(value);
        }
        return result;
    }

    private static String getArgValue(StringCodec stringCodec, CommandArgs.SingularArgument argument) {
        if (argument instanceof CommandArgs.KeyArgument) {
            CommandArgs.KeyArgument keyArg = (CommandArgs.KeyArgument)argument;
            return stringCodec.decodeKey(keyArg.codec.encodeKey(keyArg.key));
        }
        if (argument instanceof CommandArgs.ValueArgument) {
            CommandArgs.ValueArgument valueArg = (CommandArgs.ValueArgument)argument;
            return stringCodec.decodeValue(valueArg.codec.encodeValue(valueArg.val));
        }
        return argument.toString();
    }

    private OtelCommandArgsUtil() {
    }
}

