/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.instrumenter.internal;

import io.opentelemetry.instrumentation.api.incubator.instrumenter.InstrumenterCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.internal.InternalInstrumenterCustomizer;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public final class InstrumenterCustomizerImpl
implements InstrumenterCustomizer {
    private static final Map<InstrumenterCustomizer.InstrumentationType, SpanKey> typeToSpanKey = new HashMap<InstrumenterCustomizer.InstrumentationType, SpanKey>();
    private final InternalInstrumenterCustomizer customizer;

    public InstrumenterCustomizerImpl(InternalInstrumenterCustomizer customizer) {
        this.customizer = customizer;
    }

    @Override
    public String getInstrumentationName() {
        return this.customizer.getInstrumentationName();
    }

    @Override
    public boolean hasType(InstrumenterCustomizer.InstrumentationType type) {
        SpanKey spanKey = typeToSpanKey.get((Object)type);
        if (spanKey == null) {
            throw new IllegalArgumentException("unexpected instrumentation type: " + (Object)((Object)type));
        }
        return this.customizer.hasType(spanKey);
    }

    @Override
    public InstrumenterCustomizer addAttributesExtractor(AttributesExtractor<?, ?> extractor) {
        this.customizer.addAttributesExtractor(extractor);
        return this;
    }

    @Override
    public InstrumenterCustomizer addAttributesExtractors(Iterable<? extends AttributesExtractor<?, ?>> extractors) {
        this.customizer.addAttributesExtractors(extractors);
        return this;
    }

    @Override
    public InstrumenterCustomizer addOperationMetrics(OperationMetrics operationMetrics) {
        this.customizer.addOperationMetrics(operationMetrics);
        return this;
    }

    @Override
    public InstrumenterCustomizer addContextCustomizer(ContextCustomizer<?> customizer) {
        this.customizer.addContextCustomizer(customizer);
        return this;
    }

    @Override
    public InstrumenterCustomizer setSpanNameExtractor(UnaryOperator<SpanNameExtractor<?>> spanNameExtractor) {
        this.customizer.setSpanNameExtractor(spanNameExtractor);
        return this;
    }

    @Override
    public InstrumenterCustomizer setSpanStatusExtractor(UnaryOperator<SpanStatusExtractor<?, ?>> spanStatusExtractor) {
        this.customizer.setSpanStatusExtractor(spanStatusExtractor);
        return this;
    }

    static {
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.HTTP_CLIENT, SpanKey.HTTP_CLIENT);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.HTTP_SERVER, SpanKey.HTTP_SERVER);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.DB_CLIENT, SpanKey.DB_CLIENT);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.RPC_CLIENT, SpanKey.RPC_CLIENT);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.RPC_SERVER, SpanKey.RPC_SERVER);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.MESSAGING_PRODUCER, SpanKey.PRODUCER);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.MESSAGING_CONSUMER_RECEIVE, SpanKey.CONSUMER_RECEIVE);
        typeToSpanKey.put(InstrumenterCustomizer.InstrumentationType.MESSAGING_CONSUMER_PROCESS, SpanKey.CONSUMER_RECEIVE);
    }
}

