/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.messaging;

import io.opentelemetry.api.common.AttributeKey;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class CapturedMessageHeadersUtil {
    private static final ConcurrentMap<String, AttributeKey<List<String>>> attributeKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();

    static AttributeKey<List<String>> attributeKey(String headerName) {
        return attributeKeysCache.computeIfAbsent(headerName, n -> CapturedMessageHeadersUtil.createKey(n));
    }

    private static AttributeKey<List<String>> createKey(String headerName) {
        String key = "messaging.header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey((String)key);
    }

    private CapturedMessageHeadersUtil() {
    }
}

