/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.c3p0.v0_9;

import com.mchange.v2.c3p0.PooledDataSource;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.instrumentation.api.metrics.db.DbConnectionPoolMetrics;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class ConnectionPoolMetrics {
    private static final Logger logger = Logger.getLogger(ConnectionPoolMetrics.class.getName());
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.c3p0-0.9";
    private static final Map<IdentityDataSourceKey, BatchCallback> dataSourceMetrics = new ConcurrentHashMap<IdentityDataSourceKey, BatchCallback>();

    public static void registerMetrics(OpenTelemetry openTelemetry, PooledDataSource dataSource) {
        dataSourceMetrics.compute(new IdentityDataSourceKey(dataSource), (key, existingCallback) -> ConnectionPoolMetrics.createMeters(openTelemetry, key, existingCallback));
    }

    private static BatchCallback createMeters(OpenTelemetry openTelemetry, IdentityDataSourceKey key, @Nullable BatchCallback existingCallback) {
        ConnectionPoolMetrics.removeMetersFromRegistry(existingCallback);
        PooledDataSource dataSource = key.dataSource;
        DbConnectionPoolMetrics metrics = DbConnectionPoolMetrics.create((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (String)dataSource.getDataSourceName());
        ObservableLongMeasurement connections = metrics.connections();
        ObservableLongMeasurement pendingRequestsForConnection = metrics.pendingRequestsForConnection();
        Attributes attributes = metrics.getAttributes();
        Attributes usedConnectionsAttributes = metrics.getUsedConnectionsAttributes();
        Attributes idleConnectionsAttributes = metrics.getIdleConnectionsAttributes();
        return metrics.batchCallback(() -> {
            try {
                connections.record((long)dataSource.getNumBusyConnectionsDefaultUser(), usedConnectionsAttributes);
                connections.record((long)dataSource.getNumIdleConnectionsDefaultUser(), idleConnectionsAttributes);
                pendingRequestsForConnection.record((long)dataSource.getNumThreadsAwaitingCheckoutDefaultUser(), attributes);
            }
            catch (SQLException e) {
                logger.log(Level.FINE, "Failed to get C3P0 datasource metric", e);
            }
        }, (ObservableMeasurement)connections, new ObservableMeasurement[]{pendingRequestsForConnection});
    }

    public static void unregisterMetrics(PooledDataSource dataSource) {
        BatchCallback callback = dataSourceMetrics.remove(new IdentityDataSourceKey(dataSource));
        ConnectionPoolMetrics.removeMetersFromRegistry(callback);
    }

    private static void removeMetersFromRegistry(@Nullable BatchCallback callback) {
        if (callback != null) {
            callback.close();
        }
    }

    private ConnectionPoolMetrics() {
    }

    static final class IdentityDataSourceKey {
        final PooledDataSource dataSource;

        IdentityDataSourceKey(PooledDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityDataSourceKey that = (IdentityDataSourceKey)o;
            return this.dataSource == that.dataSource;
        }

        public int hashCode() {
            return System.identityHashCode(this.dataSource);
        }

        public String toString() {
            return this.dataSource.toString();
        }
    }
}

