/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant;

import io.openliberty.tools.ant.AbstractTask;
import io.openliberty.tools.ant.types.EmbeddedServerInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.ant.BuildException;

public class ServerTask
extends AbstractTask {
    private String operation;
    private String timeout;
    private boolean useEmbeddedServer;
    private String wlp;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static URLClassLoader embeddedServerClassLoader = null;
    private String embeddedServerJar = null;
    private Object embeddedServer;
    private Method embeddedServerStart;
    private Method embeddedServerStop;
    private Method embeddedServerIsRunning;
    private Method embeddedServerResultSuccessful;
    private Method embeddedServerResultReturnCode;
    private Method embeddedServerResultException;
    private static final String START_MESSAGE_CODE = "CWWKF0011I";
    private static final long SERVER_START_TIMEOUT_DEFAULT = 30000L;
    private boolean clean = false;
    private String resultProperty;
    private File archive;
    private String include;
    private String template;
    private boolean noPassword = false;
    private String os;
    private Map<String, String> environmentVariables;
    private String serverRoot;

    @Override
    protected void initTask() {
        super.initTask();
        if (isWindows) {
            String binDirectory = this.installDir + "\\bin\\";
            this.embeddedServerJar = binDirectory + "tools\\ws-server.jar";
            this.wlp = "\"" + binDirectory + "server.bat\"";
            this.processBuilder.environment().put("EXIT_ALL", "1");
        } else {
            String binDirectory = this.installDir + "/bin/";
            this.embeddedServerJar = binDirectory + "tools/ws-server.jar";
            this.wlp = binDirectory + "server";
        }
        Properties sysp = System.getProperties();
        String javaHome = sysp.getProperty("java.home");
        this.processBuilder.directory(this.installDir);
        this.processBuilder.environment().put("JAVA_HOME", javaHome);
        this.processBuilder.redirectErrorStream(true);
        if (this.environmentVariables != null) {
            this.processBuilder.environment().putAll(this.environmentVariables);
        }
    }

    public void execute() {
        block26: {
            this.initTask();
            if (this.getRuntimeConfigurableWrapper().getAttributeMap().get("id") == null && (this.operation == null || this.operation.length() <= 0)) {
                throw new BuildException(MessageFormat.format(messages.getString("error.server.operation.validate"), "operation"));
            }
            if (this.operation != null) {
                try {
                    if ("create".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server cannot be created in embedded mode.");
                        }
                        this.doCreate();
                        break block26;
                    }
                    if ("run".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            this.doEmbeddedRun();
                        } else {
                            this.doRun();
                        }
                        break block26;
                    }
                    if ("start".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            this.doEmbeddedStart();
                        } else {
                            this.doStart();
                        }
                        break block26;
                    }
                    if ("stop".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            this.doEmbeddedStop();
                        } else {
                            this.doStop();
                        }
                        break block26;
                    }
                    if ("status".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server status cannot be retrieved in embedded mode.");
                        }
                        this.doStatus();
                        break block26;
                    }
                    if ("debug".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server debug cannot be run in embedded mode. Please debug from the JVM.");
                        }
                        this.doDebug();
                        break block26;
                    }
                    if ("package".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server cannot be packaged in embedded mode.");
                        }
                        this.doPackage();
                        break block26;
                    }
                    if ("dump".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server cannot be dumped in embedded mode.");
                        }
                        this.doDump();
                        break block26;
                    }
                    if ("javadump".equals(this.operation)) {
                        if (this.useEmbeddedServer) {
                            throw new BuildException("Server cannot be dumped in embedded mode.");
                        }
                        this.doJavaDump();
                        break block26;
                    }
                    throw new BuildException("Unsupported operation: " + this.operation);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    private void initEmbeddedServer() {
        URL embeddedServerJarFile;
        try {
            embeddedServerJarFile = new File(this.embeddedServerJar).toURI().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new BuildException("Unable to locate ws-server.jar", (Throwable)e);
        }
        embeddedServerClassLoader = EmbeddedServerInfo.EmbeddedServerClassLoaders.get(embeddedServerJarFile);
        if (embeddedServerClassLoader == null) {
            embeddedServerClassLoader = new URLClassLoader(new URL[]{embeddedServerJarFile}, ((Object)((Object)this)).getClass().getClassLoader());
            EmbeddedServerInfo.EmbeddedServerClassLoaders.put(embeddedServerJarFile, embeddedServerClassLoader);
        }
        try {
            Class<?>[] embeddedServerDeclaredClasses;
            String embeddedServerClassName = "com.ibm.wsspi.kernel.embeddable.Server";
            Class<?> embeddedServerClass = Class.forName(embeddedServerClassName, true, embeddedServerClassLoader);
            Class<?> embeddedServerBuilderClass = Class.forName("com.ibm.wsspi.kernel.embeddable.ServerBuilder", true, embeddedServerClassLoader);
            Class<?> embeddedServerFutureResultClass = null;
            this.embeddedServerStart = embeddedServerClass.getMethod("start", String[].class);
            this.embeddedServerStop = embeddedServerClass.getMethod("stop", String[].class);
            this.embeddedServerIsRunning = embeddedServerClass.getMethod("isRunning", new Class[0]);
            for (Class<?> declaredClass : embeddedServerDeclaredClasses = embeddedServerClass.getDeclaredClasses()) {
                if (!(embeddedServerClassName + "$Result").equals(declaredClass.getName())) continue;
                embeddedServerFutureResultClass = declaredClass;
            }
            if (embeddedServerFutureResultClass == null) {
                throw new BuildException("Unable to load embedded server Result interface");
            }
            this.embeddedServerResultSuccessful = embeddedServerFutureResultClass.getMethod("successful", new Class[0]);
            this.embeddedServerResultReturnCode = embeddedServerFutureResultClass.getMethod("getReturnCode", new Class[0]);
            this.embeddedServerResultException = embeddedServerFutureResultClass.getMethod("getException", new Class[0]);
            Method serverBuilderSetName = embeddedServerBuilderClass.getMethod("setName", String.class);
            Method serverBuilderSetUserDir = embeddedServerBuilderClass.getMethod("setUserDir", File.class);
            Method serverBuilderSetOutputDir = embeddedServerBuilderClass.getMethod("setOutputDir", File.class);
            Method serverBuilderBuild = embeddedServerBuilderClass.getMethod("build", new Class[0]);
            EmbeddedServerInfo info = new EmbeddedServerInfo(this.getServerName(), this.getUserDir(), this.getOutputDir());
            this.embeddedServer = EmbeddedServerInfo.EmbeddedServers.get(info);
            if (this.embeddedServer == null) {
                Object serverBuilder = embeddedServerBuilderClass.newInstance();
                serverBuilder = serverBuilderSetName.invoke(serverBuilder, this.getServerName());
                serverBuilder = serverBuilderSetUserDir.invoke(serverBuilder, this.getUserDir());
                serverBuilder = serverBuilderSetOutputDir.invoke(serverBuilder, this.getOutputDir());
                this.embeddedServer = serverBuilderBuild.invoke(serverBuilder, new Object[0]);
                EmbeddedServerInfo.EmbeddedServers.put(info, this.embeddedServer);
            }
        }
        catch (Exception e) {
            throw new BuildException("Unable to load embedded Server and ServerBuilder classes", (Throwable)e);
        }
    }

    private void doEmbeddedStart() throws Exception {
        this.initEmbeddedServer();
        Future startFuture = (Future)this.embeddedServerStart.invoke(this.embeddedServer, new Object[]{EMPTY_ARRAY});
        this.getEmbeddedServerResult("start", startFuture);
    }

    private void doEmbeddedRun() throws Exception {
        this.initEmbeddedServer();
        Future startFuture = (Future)this.embeddedServerStart.invoke(this.embeddedServer, new Object[]{EMPTY_ARRAY});
        this.getEmbeddedServerResult("run", startFuture);
        while (this.isEmbeddedServerRunning()) {
            Thread.sleep(100L);
        }
    }

    private void doEmbeddedStop() throws Exception {
        this.initEmbeddedServer();
        Future stopFuture = (Future)this.embeddedServerStop.invoke(this.embeddedServer, new Object[]{EMPTY_ARRAY});
        this.getEmbeddedServerResult("stop", stopFuture);
    }

    private boolean isEmbeddedServerRunning() throws Exception {
        return (Boolean)this.embeddedServerIsRunning.invoke(this.embeddedServer, new Object[0]);
    }

    private void getEmbeddedServerResult(String action, Future<?> future) throws Exception {
        Object result = future.get();
        boolean success = (Boolean)this.embeddedServerResultSuccessful.invoke(result, new Object[0]);
        int returnCode = (Integer)this.embeddedServerResultReturnCode.invoke(result, new Object[0]);
        Object exception = this.embeddedServerResultException.invoke(result, new Object[0]);
        if (!success) {
            throw new BuildException("Embedded " + action + " failed: rc=" + returnCode + ", ex=" + exception);
        }
    }

    private void doStart() throws Exception {
        if (!this.serverConfigDir.exists()) {
            this.log(MessageFormat.format(messages.getString("info.server.create"), this.serverName));
            this.doCreate();
        }
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue(), ReturnCode.REDUNDANT_ACTION_STATUS.getValue());
        long startTimeout = 30000L;
        if (this.timeout != null && !this.timeout.equals("")) {
            startTimeout = Long.valueOf(this.timeout);
        }
        this.validateServerStarted(this.getLogFile(), startTimeout);
    }

    private void validateServerStarted(File outputFile, long startTimeout) throws Exception {
        boolean serverStarted = false;
        this.log("Waiting up to " + startTimeout / 1000L + " seconds for server confirmation:  " + START_MESSAGE_CODE.toString() + " to be found in " + outputFile);
        try {
            String startMessage = this.waitForStringInLog(START_MESSAGE_CODE, startTimeout, outputFile);
            serverStarted = startMessage != null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!serverStarted) {
            throw new BuildException(messages.getString("error.server.fail"));
        }
    }

    private void doRun() throws Exception {
        if (!this.serverConfigDir.exists()) {
            this.log(MessageFormat.format(messages.getString("info.server.create"), this.serverName));
            this.doCreate();
        }
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        final AtomicBoolean shutdown = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown.set(true);
                List stopCommand = ServerTask.this.getInitialCommand("stop");
                ServerTask.this.processBuilder.command(stopCommand);
                try {
                    Process p = ServerTask.this.processBuilder.start();
                    p.waitFor();
                }
                catch (Exception e) {
                    ServerTask.this.log("Error stopping server", e, 1);
                }
            }
        });
        int exitCode = this.getReturnCode(p, this.processBuilder.command().toString());
        if (!shutdown.get() && exitCode != ReturnCode.OK.getValue()) {
            throw new BuildException(MessageFormat.format(messages.getString("error.invoke.command"), this.processBuilder.command().toString(), exitCode, ReturnCode.OK.getValue()));
        }
    }

    private void doStop() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        String cmdLine = this.processBuilder.command().toString();
        int returnCode = this.getReturnCode(p, cmdLine);
        boolean serverStopped = false;
        if (returnCode >= 20) {
            int exitCode = this.doStatusCmd("status");
            if (exitCode == ReturnCode.REDUNDANT_ACTION_STATUS.getValue()) {
                serverStopped = true;
            }
        } else if (returnCode == ReturnCode.OK.getValue() || returnCode == ReturnCode.REDUNDANT_ACTION_STATUS.getValue()) {
            serverStopped = true;
        }
        if (!serverStopped) {
            this.sendErrorInvokeCommand(cmdLine, returnCode, ReturnCode.OK.getValue(), ReturnCode.REDUNDANT_ACTION_STATUS.getValue());
        }
    }

    private void doStatus() throws Exception {
        int exitCode = this.doStatusCmd(this.operation);
        if (this.resultProperty == null) {
            this.resultProperty = "wlp." + this.serverName + ".status";
        }
        this.getProject().setUserProperty(this.resultProperty, String.valueOf(exitCode));
    }

    private int doStatusCmd(String cmd) throws Exception {
        List<String> command = this.getInitialCommand(cmd);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        return this.getReturnCode(p, this.processBuilder.command().toString());
    }

    private void doDump() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addArchiveOption(command);
        this.addIncludeOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doJavaDump() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addIncludeOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doPackage() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addArchiveOption(command);
        this.addIncludeOption(command);
        this.addOsOption(command);
        this.addServerRootOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doCreate() throws Exception {
        List<String> command = this.getInitialCommand("create");
        if (this.template != null) {
            command.add("--template=" + this.template);
        }
        this.addNoPasswordOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doDebug() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private List<String> getInitialCommand(String operation) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.wlp);
        commands.add(operation);
        if (this.serverName != null && !this.serverName.equals("")) {
            commands.add(this.serverName);
        }
        return commands;
    }

    private void addArchiveOption(List<String> command) {
        if (this.archive != null) {
            if (this.archive.isDirectory()) {
                throw new BuildException("The archive attribute must specify a file");
            }
            if (isWindows) {
                String archivePath = this.archive.toString();
                if (archivePath.contains(" ")) {
                    command.add("\"--archive=" + archivePath + "\"");
                } else {
                    command.add("--archive=\"" + archivePath + "\"");
                }
            } else {
                command.add("--archive=" + this.archive.toString().replaceAll(" ", "\\\\ "));
            }
        }
    }

    private void addIncludeOption(List<String> command) {
        if (this.include != null) {
            command.add("--include=" + this.include);
        }
    }

    private void addOsOption(List<String> command) {
        if (this.os != null) {
            command.add("--os=" + this.os);
        }
    }

    private void addServerRootOption(List<String> command) {
        if (this.serverRoot != null) {
            command.add("--server-root=" + this.serverRoot);
        }
    }

    private void addCleanOption(List<String> command) {
        if (this.clean) {
            command.add("--clean");
        }
    }

    private void addNoPasswordOption(List<String> command) {
        if (this.noPassword) {
            command.add("--no-password");
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public String getResultProperty() {
        return this.resultProperty;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isNoPassword() {
        return this.noPassword;
    }

    public void setNoPassword(boolean noPassword) {
        this.noPassword = noPassword;
    }

    public void setUseEmbeddedServer(boolean useEmbeddedServer) {
        this.useEmbeddedServer = useEmbeddedServer;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static enum ReturnCode {
        OK(0),
        REDUNDANT_ACTION_STATUS(1),
        SERVER_NOT_EXIST_STATUS(2),
        SERVER_ACTIVE_STATUS(3),
        SERVER_INACTIVE_STATUS(4),
        BAD_ARGUMENT(20),
        ERROR_SERVER_STOP(21),
        ERROR_SERVER_START(22),
        LOCATION_EXCEPTION(23),
        LAUNCH_EXCEPTION(24),
        RUNTIME_EXCEPTION(25),
        UNKNOWN_EXCEPTION(26),
        PROCESS_CLIENT_EXCEPTION(27),
        ERROR_SERVER_PACKAGE(28),
        ERROR_SERVER_DUMP(29),
        ERROR_SERVER_ATTACH(30);

        final int val;

        private ReturnCode(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

