/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant;

import io.openliberty.tools.ant.ServerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractTask
extends Task {
    protected File installDir;
    protected File userDir;
    protected File outputDir;
    protected File serverConfigDir = null;
    protected File serverOutputDir = null;
    protected String serverName;
    protected String ref;
    protected static String osName;
    protected static boolean isWindows;
    protected ProcessBuilder processBuilder;
    protected static final String DEFAULT_SERVER = "defaultServer";
    protected static final String DEFAULT_LOG_FILE = "logs/messages.log";
    protected static final String WLP_USER_DIR_VAR = "WLP_USER_DIR";
    protected static final String WLP_OUTPUT_DIR_VAR = "WLP_OUTPUT_DIR";
    protected static final ResourceBundle messages;

    protected void initTask() {
        Object serverRef;
        if (this.ref != null && (serverRef = this.getProject().getReference(this.ref)) != null && serverRef instanceof ServerTask) {
            this.setInstallDir(((ServerTask)((Object)serverRef)).getInstallDir());
            this.setServerName(((ServerTask)((Object)serverRef)).getServerName());
            this.setUserDir(((ServerTask)((Object)serverRef)).getUserDir());
            this.setOutputDir(((ServerTask)((Object)serverRef)).getOutputDir());
        }
        try {
            if (this.installDir != null) {
                this.installDir = this.installDir.getCanonicalFile();
                File file = new File(this.installDir, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new BuildException(messages.getString("error.installDir.set"));
                }
            } else {
                throw new BuildException("Liberty installation directory must be set.");
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "installDir", this.installDir.getCanonicalPath()), 3);
            if (this.serverName == null) {
                this.setServerName(DEFAULT_SERVER);
            }
            this.processBuilder = new ProcessBuilder(new String[0]);
            if (this.userDir != null) {
                this.log(MessageFormat.format(messages.getString("info.variable"), "userDir", this.userDir.getCanonicalPath()), 3);
                this.processBuilder.environment().put(WLP_USER_DIR_VAR, this.userDir.getCanonicalPath());
                this.serverConfigDir = new File(this.userDir, "servers/" + this.serverName);
            } else {
                String wlpUserDir = this.processBuilder.environment().get(WLP_USER_DIR_VAR);
                if (wlpUserDir != null) {
                    this.log(MessageFormat.format(messages.getString("info.variable"), WLP_USER_DIR_VAR, wlpUserDir), 3);
                    this.serverConfigDir = new File(wlpUserDir, "servers/" + this.serverName);
                } else {
                    this.serverConfigDir = new File(this.installDir, "usr/servers/" + this.serverName);
                }
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "server.config.dir", this.serverConfigDir.getCanonicalPath()), 3);
            if (this.outputDir != null) {
                this.log(MessageFormat.format(messages.getString("info.variable"), "outputDir", this.outputDir.getCanonicalPath()), 3);
                this.processBuilder.environment().put(WLP_OUTPUT_DIR_VAR, this.outputDir.getCanonicalPath());
                this.serverOutputDir = new File(this.outputDir, this.serverName);
            } else {
                String wlpOutputDir = this.processBuilder.environment().get(WLP_OUTPUT_DIR_VAR);
                if (wlpOutputDir != null) {
                    this.log(MessageFormat.format(messages.getString("info.variable"), WLP_OUTPUT_DIR_VAR, wlpOutputDir), 3);
                    this.serverOutputDir = new File(wlpOutputDir, this.serverName);
                } else {
                    this.serverOutputDir = this.serverConfigDir;
                }
            }
            this.log(MessageFormat.format(messages.getString("info.variable"), "server.output.dir", this.serverOutputDir.getCanonicalPath()), 3);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        osName = System.getProperty("os.name", "unknown").toLowerCase();
        isWindows = osName.indexOf("windows") >= 0;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(File installDir) {
        this.installDir = installDir;
    }

    public File getUserDir() {
        return this.userDir;
    }

    public void setUserDir(File userDir) {
        this.userDir = userDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getServerOutputDir() {
        return this.serverOutputDir;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public File getLogFile() {
        return new File(this.serverOutputDir, DEFAULT_LOG_FILE);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    protected int getReturnCode(Process p, String commandLine) throws InterruptedException {
        this.log(MessageFormat.format(messages.getString("info.variable"), "Invoke command", commandLine, 3));
        StreamCopier copier = new StreamCopier(p.getInputStream());
        copier.start();
        int exitVal = p.waitFor();
        copier.doJoin();
        copier.cleanup();
        return exitVal;
    }

    public void checkReturnCode(Process p, String commandLine, int ... expectedExitCodes) throws InterruptedException {
        int exitVal = this.getReturnCode(p, commandLine);
        for (int expectedExitCode : expectedExitCodes) {
            if (exitVal != expectedExitCode) continue;
            return;
        }
        this.sendErrorInvokeCommand(commandLine, exitVal, expectedExitCodes);
    }

    public void checkReturnCodeAndError(Process p, String commandLine, int expectedExitCode, int allowedExitCode, String allowedErrorMessage) throws InterruptedException {
        this.log(MessageFormat.format(messages.getString("info.variable"), "Invoke command", commandLine, 3));
        StreamCopier copier = new StreamCopier(p.getInputStream());
        copier.start();
        int exitVal = p.waitFor();
        copier.doJoin();
        String stdOutAndError = copier.getOutput();
        copier.cleanup();
        if (exitVal == expectedExitCode) {
            return;
        }
        if (exitVal == allowedExitCode && stdOutAndError.startsWith(allowedErrorMessage)) {
            this.log("The command " + commandLine + " failed with return code 21 with this error message: " + stdOutAndError, 1);
            return;
        }
        this.sendErrorInvokeCommand(commandLine, exitVal, expectedExitCode);
    }

    public void sendErrorInvokeCommand(String commandLine, int returnCode, int ... expectedExitCodes) {
        throw new BuildException(MessageFormat.format(messages.getString("error.invoke.command"), commandLine, returnCode, Arrays.toString(expectedExitCodes)));
    }

    public String waitForStringInLog(String regexp, long timeout, File outputFile) {
        long waitIncrement = 500L;
        this.log(MessageFormat.format(messages.getString("info.search.string"), regexp, outputFile.getAbsolutePath(), timeout / 1000L));
        for (long waited = 0L; waited <= timeout; waited += 500L) {
            String string = this.findStringInFile(regexp, outputFile, 2);
            if (string == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            return string;
        }
        this.log(MessageFormat.format(messages.getString("error.serch.string.timeout"), regexp, outputFile.getAbsolutePath()));
        return null;
    }

    public String findStringInFile(String regexp, File fileToSearch) {
        return this.findStringInFile(regexp, fileToSearch, 3);
    }

    public List<String> findStringsInFile(String regexp, File fileToSearch) {
        return this.findStringsInFileCommon(regexp, false, -1, fileToSearch, 3);
    }

    private String findStringInFile(String regexp, File fileToSearch, int msgLevel) {
        String foundString = null;
        List<String> matches = this.findStringsInFileCommon(regexp, true, -1, fileToSearch, msgLevel);
        if (matches != null && !matches.isEmpty()) {
            foundString = matches.get(0);
        }
        return foundString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findStringsInFileCommon(String regexp, boolean stopOnFirst, int searchLimit, File fileToSearch, int msgLevel) {
        if (fileToSearch == null) {
            this.log(messages.getString("info.file.validated"));
            return null;
        }
        if (!fileToSearch.exists()) {
            try {
                this.log(MessageFormat.format(messages.getString("info.file.validate.noexist"), fileToSearch.getCanonicalPath()));
            }
            catch (IOException e) {
                this.log(MessageFormat.format(messages.getString("info.file.validate.noexist"), fileToSearch.getAbsolutePath()));
            }
            return null;
        }
        FileInputStream serverOutput = null;
        InputStreamReader in = null;
        Scanner s = null;
        ArrayList<String> matches = null;
        try {
            serverOutput = new FileInputStream(fileToSearch);
            in = new InputStreamReader(serverOutput);
            s = new Scanner(in);
            this.log(MessageFormat.format(messages.getString("info.look.string.infile"), regexp, fileToSearch.getName()), 3);
            String foundString = null;
            Pattern pattern = Pattern.compile(regexp);
            matches = new ArrayList<String>();
            while (s.hasNextLine()) {
                if (foundString != null && stopOnFirst) {
                    break;
                }
                if (searchLimit <= 0 && searchLimit >= matches.size()) {
                    break;
                }
                String line = s.nextLine();
                if (!pattern.matcher(line).find()) continue;
                foundString = line;
                matches.add(line);
                this.log(MessageFormat.format(messages.getString("info.match.string"), matches.size(), line), msgLevel);
            }
        }
        catch (Exception e) {
            this.log(e.toString());
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                ((InputStream)serverOutput).close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return matches;
    }

    public int countStringOccurrencesInFile(String regexp, File fileToSearch) {
        List<String> lines = this.findStringsInFileCommon(regexp, false, -1, fileToSearch, 3);
        if (lines == null) {
            return 0;
        }
        return lines.size();
    }

    public String waitForUpdatedStringInLog(String regexp, long timeout, File outputFile, int previousOccurrences) {
        long waitIncrement = 500L;
        this.log(MessageFormat.format(messages.getString("info.search.string"), regexp, outputFile.getAbsolutePath(), timeout / 1000L));
        for (long waited = 0L; waited <= timeout; waited += 500L) {
            List<String> matches = this.findStringsInFileCommon(regexp, false, -1, outputFile, 3);
            if (matches == null || matches.size() <= previousOccurrences) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            String line = matches.get(matches.size() - 1);
            this.log(MessageFormat.format(messages.getString("info.match.string"), matches.size(), line), 2);
            return line;
        }
        this.log(MessageFormat.format(messages.getString("error.serch.string.timeout"), regexp, outputFile.getAbsolutePath()));
        return null;
    }

    protected String getFileName(String fileName) {
        int index;
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return (index = fileName.lastIndexOf(46)) == -1 ? fileName : fileName.substring(0, index);
    }

    protected void stopServer(String timeout) {
        ServerTask st = new ServerTask();
        st.setProject(this.getProject());
        st.setInstallDir(this.getInstallDir());
        st.setUserDir(this.getUserDir());
        st.setOutputDir(this.getOutputDir());
        st.setServerName(this.getServerName());
        st.setTimeout(timeout);
        st.setOperation("stop");
        st.execute();
    }

    protected String getMessage(String key, Object ... args) {
        return MessageFormat.format(messages.getString(key), args);
    }

    static {
        messages = ResourceBundle.getBundle("io.openliberty.tools.ant.AntMessages");
    }

    private class StreamCopier
    extends Thread {
        private final BufferedReader reader;
        private boolean joined;
        private boolean terminated;
        private StringBuilder sb;

        StreamCopier(InputStream input) {
            this.reader = new BufferedReader(new InputStreamReader(input));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Object line;
                this.sb = new StringBuilder();
                while ((line = this.reader.readLine()) != null) {
                    StreamCopier streamCopier = this;
                    synchronized (streamCopier) {
                        if (this.joined) {
                            return;
                        }
                        this.sb.append((String)line);
                        AbstractTask.this.log((String)line);
                    }
                }
                return;
            }
            catch (IOException ex) {
                this.sb.setLength(0);
                throw new BuildException((Throwable)ex);
            }
            finally {
                if (isWindows) {
                    StreamCopier streamCopier = this;
                    synchronized (streamCopier) {
                        this.terminated = true;
                        this.notifyAll();
                    }
                }
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public String getOutput() {
            if (this.sb != null) {
                return this.sb.toString();
            }
            return "";
        }

        public void cleanup() {
            if (this.sb != null) {
                this.sb.setLength(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doJoin() throws InterruptedException {
            if (isWindows) {
                StreamCopier streamCopier = this;
                synchronized (streamCopier) {
                    long begin = System.nanoTime();
                    long end = begin + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
                    long duration = end - begin;
                    while (!this.terminated && duration > 0L) {
                        TimeUnit.NANOSECONDS.timedWait(this, duration);
                        duration = end - System.nanoTime();
                    }
                    this.joined = true;
                }
            } else {
                super.join();
            }
        }
    }
}

