/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public abstract class AbstractContainerSupportUtil {
    public abstract void debug(String var1);

    public abstract void error(String var1, Throwable var2);

    protected String execDockerCmd(String command, int timeout, boolean throwExceptionOnError) {
        String result = null;
        try {
            this.debug("execDocker, timeout=" + timeout + ", cmd=" + command);
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor(timeout, TimeUnit.SECONDS);
            if (p.exitValue() != 0) {
                this.debug("Error running docker command, return value=" + p.exitValue());
                char[] d = new char[1023];
                new InputStreamReader(p.getErrorStream()).read(d);
                String errorMessage = new String(d).trim() + " RC=" + p.exitValue();
                if (throwExceptionOnError) {
                    throw new RuntimeException(errorMessage);
                }
                return errorMessage;
            }
            result = this.readStdOut(p);
        }
        catch (IllegalThreadStateException e) {
            this.debug("IllegalThreadStateException, message=" + e.getMessage());
            this.error("The docker command did not complete within the timeout period: " + timeout + " seconds.", e);
            throw new RuntimeException("The docker command did not complete within the timeout period: " + timeout + " seconds. ");
        }
        catch (InterruptedException e) {
            this.error("An interruption error occurred while running a docker command: " + e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            this.error("An error occurred while running a docker command: " + e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    protected String readStdOut(Process p) throws IOException, InterruptedException {
        String line;
        String result = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuffer allLines = new StringBuffer();
        while ((line = in.readLine()) != null) {
            allLines.append(line).append(" ");
        }
        if (allLines.length() > 0) {
            result = allLines.toString();
        }
        return result;
    }
}

