/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.GenericFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipGenericFile
extends File
implements GenericFile {
    private static final long serialVersionUID = -8616693308908035499L;
    private final ZipFile zf;
    private final String name;

    public ZipGenericFile(File file) throws IOException {
        super(file.getAbsolutePath());
        if (file instanceof ZipGenericFile) {
            ZipGenericFile zFile = (ZipGenericFile)file;
            this.zf = zFile.zf;
            this.name = zFile.name;
        } else {
            this.zf = new ZipFile(this);
            this.name = null;
        }
    }

    private ZipGenericFile(ZipGenericFile parent, String child) {
        super(parent, child);
        this.zf = parent.zf;
        String tmpName = child;
        if (parent.name != null) {
            tmpName = parent.name + tmpName;
        }
        if (!tmpName.endsWith("/") && this.zf != null && this.zf.getEntry(tmpName + "/") != null) {
            tmpName = tmpName + "/";
        }
        this.name = tmpName;
    }

    @Override
    public File getChild(String name) {
        return new ZipGenericFile(this, name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.zf == null) {
            throw new IOException("File does not exists.");
        }
        if (this.name == null) {
            throw new IOException("Root entry is not a file.");
        }
        ZipEntry entry = this.zf.getEntry(this.name);
        if (entry.isDirectory()) {
            throw new IOException("This entry is a directory.");
        }
        return this.zf.getInputStream(entry);
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ZipGenericFile && super.equals(obj);
    }

    @Override
    public boolean exists() {
        return this.zf != null && (this.name == null || this.zf.getEntry(this.name) != null);
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFreeSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getUsableSpace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        if (this.zf == null) {
            return false;
        }
        if (this.name == null) {
            return true;
        }
        ZipEntry ze = this.zf.getEntry(this.name);
        return ze != null && ze.isDirectory();
    }

    @Override
    public boolean isFile() {
        if (this.zf == null) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        ZipEntry ze = this.zf.getEntry(this.name);
        return ze != null && !ze.isDirectory();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        if (this.zf == null) {
            return 0L;
        }
        if (this.name == null) {
            return super.lastModified();
        }
        ZipEntry ze = this.zf.getEntry(this.name);
        return ze != null ? ze.getTime() : 0L;
    }

    @Override
    public long length() {
        if (this.zf == null) {
            return 0L;
        }
        if (this.name == null) {
            return super.length();
        }
        ZipEntry ze = this.zf.getEntry(this.name);
        return ze != null ? ze.getSize() : 0L;
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        Enumeration<? extends ZipEntry> entries = this.zf.entries();
        HashSet<String> names = new HashSet<String>();
        while (entries.hasMoreElements()) {
            int index;
            String entry = entries.nextElement().getName();
            if (this.name != null && !entry.startsWith(this.name)) continue;
            if (this.name != null) {
                entry = entry.substring(this.name.length());
            }
            if ((index = entry.indexOf(47)) >= 0) {
                entry = entry.substring(0, index + 1);
            }
            if (entry.isEmpty() || filter != null && !filter.accept(this, entry)) continue;
            names.add(entry);
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        String[] names = this.list();
        if (names == null) {
            return null;
        }
        ArrayList<ZipGenericFile> result = new ArrayList<ZipGenericFile>();
        for (int i = 0; i < names.length; ++i) {
            ZipGenericFile file = new ZipGenericFile(this, names[i]);
            if (filter != null && !filter.accept(file)) continue;
            result.add(file);
        }
        return result.toArray(new ZipGenericFile[result.size()]);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        String[] names = this.list(filter);
        if (names == null) {
            return null;
        }
        File[] result = new ZipGenericFile[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = new ZipGenericFile(this, names[i]);
        }
        return result;
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mkdirs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean renameTo(File dest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setLastModified(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        throw new UnsupportedOperationException();
    }
}

