/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogFileWriter;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractBufferedLogFileWriter
implements LogFileWriter {
    private static final String OUT_BUFFER_SIZE_PROPERTY_NAME = "HPEL.BUFFER.SIZE";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static int bufferSize;
    private static final String FLUSH_PERIOD_PROPERTY_NAME = "HPEL.FLUSH.PERIOD.SECS";
    private static final long DEFAULT_FLUSH_PERIOD_SECS = 10L;
    private static long flushPeriod;
    private final File file;
    protected final OutputStream fileStream;
    private Timer flushTimer = null;

    AbstractBufferedLogFileWriter(File file, boolean bufferingEnabled) throws IOException {
        this.file = file;
        if (bufferingEnabled) {
            this.flushTimer = AccessHelper.createTimer();
        }
        if (bufferingEnabled && this.flushTimer != null) {
            this.fileStream = new BufferedOutputStream(AccessHelper.createFileOutputStream(file, false), bufferSize);
            this.flushTimer.schedule((TimerTask)new flushTask(), flushPeriod, flushPeriod);
        } else {
            this.fileStream = AccessHelper.createFileOutputStream(file, false);
        }
    }

    private static String getSystemProperty(final String flushPeriodPropertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(flushPeriodPropertyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(byte[] tail) throws IOException {
        OutputStream outputStream = this.fileStream;
        synchronized (outputStream) {
            if (this.flushTimer != null) {
                this.flushTimer.cancel();
                this.flushTimer = null;
            }
            this.fileStream.flush();
            this.fileStream.close();
        }
    }

    @Override
    public File currentFile() {
        return this.file;
    }

    @Override
    public void flush() throws IOException {
        if (this.flushTimer == null) {
            this.fileStream.flush();
        }
    }

    static {
        String flushPeriodStr;
        String bufferSizeStr = AbstractBufferedLogFileWriter.getSystemProperty(OUT_BUFFER_SIZE_PROPERTY_NAME);
        if (bufferSizeStr != null) {
            try {
                bufferSize = Integer.decode(bufferSizeStr);
            }
            catch (NumberFormatException e) {
                bufferSize = 8192;
            }
        } else {
            bufferSize = 8192;
        }
        if ((flushPeriodStr = AbstractBufferedLogFileWriter.getSystemProperty(FLUSH_PERIOD_PROPERTY_NAME)) != null) {
            try {
                flushPeriod = Long.decode(flushPeriodStr);
            }
            catch (NumberFormatException e) {
                flushPeriod = 10L;
            }
        } else {
            flushPeriod = 10L;
        }
        flushPeriod *= 1000L;
    }

    private class flushTask
    extends TimerTask {
        private flushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                OutputStream outputStream = AbstractBufferedLogFileWriter.this.fileStream;
                synchronized (outputStream) {
                    if (AbstractBufferedLogFileWriter.this.flushTimer != null) {
                        AbstractBufferedLogFileWriter.this.fileStream.flush();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

