/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.transport.client.AbstractFileClient;
import com.ibm.ws.repository.transport.client.DirectoryUtils;
import com.ibm.ws.repository.transport.client.FileDataCache;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.CopyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.manifest.ManifestProcessor;

public class ZipClient
extends AbstractFileClient {
    private final File _zip;
    private final FileDataCache<List<Asset>> _allAssetsCache;

    public ZipClient(File zip) {
        this._zip = zip;
        this._allAssetsCache = new FileDataCache(zip, this);
    }

    @Override
    public void checkRepositoryStatus() throws IOException {
        if (!DirectoryUtils.exists(this._zip)) {
            throw new FileNotFoundException("Could not find " + this._zip);
        }
        ZipFile zip = DirectoryUtils.createZipFile(this._zip);
        zip.close();
    }

    @Override
    public List<Asset> getAllAssets() throws IOException {
        return CopyUtils.copyCollection(this._allAssetsCache.get(() -> super.getAllAssets()), Asset::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAttachment(Asset asset, Attachment attachment) throws IOException, BadVersionException, RequestFailureException {
        final ZipFile repoZip = this.createZipFile();
        if (null == repoZip) {
            return null;
        }
        InputStream retInputStream = null;
        String attachmentId = attachment.get_id();
        try {
            if (attachmentId.contains("#")) {
                String assetId = asset.get_id();
                ZipEntry entry = this.createFromRelative(assetId);
                if (null == entry) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                ZipInputStream zis = new ZipInputStream(repoZip.getInputStream(entry));
                retInputStream = this.getInputStreamToLicenseInsideZip(zis, assetId, attachmentId);
            } else {
                ZipEntry entry = this.createFromRelative(attachmentId);
                retInputStream = repoZip.getInputStream(entry);
            }
        }
        finally {
            if (retInputStream == null) {
                repoZip.close();
            }
        }
        final InputStream is = retInputStream;
        InputStream wrappedIs = new InputStream(){

            @Override
            public int read(byte[] b) throws IOException {
                return is.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return is.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return is.skip(n);
            }

            @Override
            public int available() throws IOException {
                return is.available();
            }

            @Override
            public synchronized void mark(int readlimit) {
                is.mark(readlimit);
            }

            @Override
            public synchronized void reset() throws IOException {
                is.reset();
            }

            @Override
            public boolean markSupported() {
                return is.markSupported();
            }

            @Override
            public int read() throws IOException {
                return is.read();
            }

            @Override
            public void close() throws IOException {
                is.close();
                repoZip.close();
            }
        };
        return wrappedIs;
    }

    @Override
    protected boolean exists(String relative) {
        return this.createFromRelative(relative) != null;
    }

    @Override
    protected boolean hasChildren(String relative) throws IOException {
        ZipFile zip = this.createZipFile();
        if (null == zip) {
            return false;
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!relative.equals("") && !entry.getName().startsWith(relative + File.separator)) continue;
            return true;
        }
        zip.close();
        return false;
    }

    @Override
    protected Collection<String> getChildren(String relative) throws IOException {
        ZipFile zip = this.createZipFile();
        if (null == zip) {
            return Collections.emptyList();
        }
        ArrayList<String> children = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !relative.equals("") && !entry.getName().startsWith(relative + File.separator)) continue;
            children.add(entry.getName());
        }
        zip.close();
        return children;
    }

    @Override
    protected long getSize(String relative) {
        ZipEntry entry = this.createFromRelative(relative);
        return entry == null ? 0L : entry.getSize();
    }

    protected ZipEntry createFromRelative(String relative) {
        ZipFile zip = null;
        ZipEntry entry = null;
        zip = this.createZipFile();
        if (null == zip) {
            return null;
        }
        entry = zip.getEntry(relative);
        try {
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Asset readJson(String assetId) throws IOException, BadVersionException {
        ZipFile zip = this.createZipFile();
        ZipEntry entry = this.createFromRelative(assetId + ".json");
        if (entry != null) {
            InputStream is = null;
            try {
                Asset ass;
                is = zip.getInputStream(entry);
                Asset asset = ass = this.processJSON(is);
                return asset;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                zip.close();
            }
        }
        zip.close();
        throw new IOException("The asset " + assetId + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Long> getLicenses(String assetId) throws IOException {
        boolean isEsa = assetId.toLowerCase().endsWith(".esa");
        HashMap<String, Long> licenses = new HashMap<String, Long>();
        ZipFile repoZip = this.createZipFile();
        if (repoZip == null) {
            return licenses;
        }
        ZipEntry innerZip = this.createFromRelative(assetId);
        String liLocation = this.getHeader(assetId, isEsa ? "IBM-License-Information" : "License-Information");
        String laLocation = this.getHeader(assetId, isEsa ? "IBM-License-Agreement" : "License-Agreement");
        if (liLocation != null || laLocation != null) {
            ZipInputStream zis = new ZipInputStream(repoZip.getInputStream(innerZip));
            try {
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (!ze.isDirectory() && (liLocation != null && ze.getName().startsWith(liLocation) || laLocation != null && ze.getName().startsWith(laLocation))) {
                        licenses.put(ze.getName().replace("/", File.separator), ze.getSize());
                    }
                    ze = zis.getNextEntry();
                }
            }
            finally {
                if (zis != null) {
                    zis.closeEntry();
                    zis.close();
                }
                repoZip.close();
            }
        }
        return licenses;
    }

    @Override
    protected String getHeader(String assetId, String type) throws IOException {
        Manifest mf = this.getManifest(assetId);
        if (null == mf) {
            return null;
        }
        return this.getManifest(assetId).getMainAttributes().getValue(type);
    }

    protected Manifest getManifest(String assetId) throws IOException {
        boolean isEsa = assetId.toLowerCase().endsWith(".esa");
        if (isEsa) {
            return this.getSubsystemManifest(assetId);
        }
        return this.getJarManifest(assetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getSubsystemManifest(String assetId) throws IOException {
        try (ZipFile repoZip = null;){
            repoZip = this.createZipFile();
            ZipEntry entry = this.createFromRelative(assetId);
            if (null == repoZip || null == entry) {
                Manifest manifest = null;
                return manifest;
            }
            ZipInputStream zis = new ZipInputStream(repoZip.getInputStream(entry));
            ZipEntry innerEntry = zis.getNextEntry();
            ZipEntry subsystemEntry = null;
            while (null != innerEntry) {
                if ("OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(innerEntry.getName())) {
                    subsystemEntry = innerEntry;
                    break;
                }
                innerEntry = zis.getNextEntry();
            }
            if (subsystemEntry == null) {
                Manifest manifest = null;
                return manifest;
            }
            Manifest manifest = ManifestProcessor.parseManifest((InputStream)zis);
            return manifest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getJarManifest(String assetId) throws IOException {
        Manifest manifest = new Manifest();
        try (ZipFile repoZip = null;){
            repoZip = this.createZipFile();
            ZipEntry entry = this.createFromRelative(assetId);
            if (null == entry) {
                Manifest manifest2 = null;
                return manifest2;
            }
            ZipInputStream zis = new ZipInputStream(repoZip.getInputStream(entry));
            ZipEntry innerEntry = zis.getNextEntry();
            while (null != innerEntry) {
                if ("meta-inf/manifest.mf".equalsIgnoreCase(innerEntry.getName())) {
                    manifest.read(zis);
                    break;
                }
                innerEntry = zis.getNextEntry();
            }
        }
        return manifest;
    }

    protected ZipFile createZipFile() {
        try {
            ZipFile zip = DirectoryUtils.createZipFile(this._zip);
            return zip;
        }
        catch (IOException e) {
            return null;
        }
    }
}

