/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.resources.internal.ProductResourceImpl;
import com.ibm.ws.repository.resources.writeable.ProductRelatedResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ProductRelatedParser<T extends ProductRelatedResourceWritable>
extends ParserBase
implements Parser<T> {
    static final long serialVersionUID = 2151333805096904206L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected abstract AssetInformation extractInformationFromAsset(File var1, ParserBase.ArtifactMetadata var2) throws ProductInfoParseException, IOException, PrivilegedActionException;

    /*
     * WARNING - void declaration
     */
    @Override
    public T parseFileToResource(File archive, File metadataFile, String contentUrl) throws RepositoryException {
        AssetInformation assetInformation;
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(archive, metadataFile);
        try {
            assetInformation = this.extractInformationFromAsset(archive, artifactMetadata);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ProductRelatedParser", (String)"95", (Object)this, (Object[])new Object[]{archive, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), archive, (Throwable)e);
        }
        catch (ProductInfoParseException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.ProductRelatedParser", (String)"97", (Object)this, (Object[])new Object[]{archive, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), archive, e);
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.ProductRelatedParser", (String)"99", (Object)this, (Object[])new Object[]{archive, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getCause().getMessage(), archive, e.getCause());
        }
        ProductRelatedResourceWritable resource = (ProductRelatedResourceWritable)WritableResourceFactory.createResource(null, (ResourceType)assetInformation.type);
        this.addContent((RepositoryResourceWritable)resource, archive, archive.getName(), artifactMetadata, contentUrl);
        String provFeat = assetInformation.provideFeature;
        if (provFeat != null) {
            ArrayList<String> providesList = new ArrayList<String>();
            StringTokenizer featuresTokenizer = new StringTokenizer(provFeat, ",");
            while (featuresTokenizer.hasMoreElements()) {
                String nextFeature = (String)featuresTokenizer.nextElement();
                providesList.add(nextFeature);
            }
            resource.setProvideFeature(providesList);
        }
        if (assetInformation.type.equals((Object)ResourceType.ADDON)) {
            String reqFeat = assetInformation.requireFeature;
            if (reqFeat != null) {
                ArrayList<String> requiresList = new ArrayList<String>();
                StringTokenizer featuresTokenizer = new StringTokenizer(reqFeat, ",");
                while (featuresTokenizer.hasMoreElements()) {
                    String nextFeature = (String)featuresTokenizer.nextElement();
                    requiresList.add(nextFeature);
                }
                resource.setRequireFeature(requiresList);
            }
            ((ProductResourceImpl)resource).setAppliesTo(assetInformation.appliesTo);
        }
        boolean keepLooking = true;
        ArrayList<Object> orderedProductInfos = new ArrayList<Object>();
        orderedProductInfos.add(assetInformation.websphereProductInfo);
        block8: while (keepLooking) {
            keepLooking = false;
            for (Object pi : assetInformation.infosList) {
                String string = pi.getReplacesId();
                if (string == null || !string.equals(assetInformation.websphereProductInfo.getId())) continue;
                assetInformation.websphereProductInfo = (ProductInfo)pi;
                orderedProductInfos.add(0, pi);
                keepLooking = true;
                continue block8;
            }
        }
        String productInstallType = null;
        if (assetInformation.websphereProductInfo != null) {
            ProductInfo productInfo;
            Object pi;
            for (ProductInfo productInfo2 : orderedProductInfos) {
                String version = productInfo2.getVersion();
                if (version == null || version.isEmpty()) continue;
                resource.setProductVersion(version);
                break;
            }
            for (ProductInfo productInfo3 : orderedProductInfos) {
                String id = productInfo3.getId();
                if (id == null || id.isEmpty()) continue;
                resource.setProductId(id);
                break;
            }
            for (ProductInfo productInfo4 : orderedProductInfos) {
                String edition = productInfo4.getEdition();
                if (edition == null || edition.isEmpty()) continue;
                resource.setProductEdition(edition);
                break;
            }
            pi = orderedProductInfos.iterator();
            while (pi.hasNext() && ((productInstallType = (productInfo = (ProductInfo)pi.next()).getProperty("com.ibm.websphere.productInstallType")) == null || productInstallType.isEmpty())) {
            }
        }
        if (productInstallType == null || productInstallType.isEmpty()) {
            productInstallType = "Archive";
        }
        resource.setProductInstallType(productInstallType);
        resource.setProviderName("IBM");
        resource.setDisplayPolicy(DisplayPolicy.VISIBLE);
        resource.setWebDisplayPolicy(DisplayPolicy.VISIBLE);
        this.setCommonFieldsFromSideZip(artifactMetadata, (RepositoryResourceWritable)resource);
        if (assetInformation.genericRequirements != null && !assetInformation.genericRequirements.isEmpty()) {
            String requirements = assetInformation.genericRequirements;
            resource.setGenericRequirements(requirements);
        }
        if (assetInformation.packagedJava != null && !assetInformation.packagedJava.isEmpty()) {
            resource.setPackagedJava(assetInformation.packagedJava);
        }
        this.attachLicenseData(artifactMetadata, (RepositoryResourceWritable)resource);
        try {
            this.processLAandLI(assetInformation.fileWithLicensesIn, (RepositoryResourceWritable)resource, assetInformation.laLocation, assetInformation.liLocation);
        }
        catch (IOException requirements) {
            void e;
            FFDCFilter.processException((Throwable)requirements, (String)"com.ibm.ws.repository.parsers.ProductRelatedParser", (String)"223", (Object)this, (Object[])new Object[]{archive, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), archive, (Throwable)e);
        }
        return (T)resource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ProductRelatedParser", ProductRelatedParser.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class AssetInformation {
        private final Logger _logger = Logger.getLogger(AssetInformation.class.getName());
        protected ResourceType type;
        private ProductInfo websphereProductInfo;
        private final List<ProductInfo> infosList = new ArrayList<ProductInfo>();
        protected String provideFeature;
        protected String requireFeature;
        protected String genericRequirements;
        protected String packagedJava;
        public String appliesTo;
        public String laLocation;
        public String liLocation;
        public File fileWithLicensesIn;
        static final long serialVersionUID = -6489652959394520354L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AssetInformation() {
        }

        protected void addProductInfos(ZipFile archiveContainingProductInfos, String rootDir, File archiveFile) throws ProductInfoParseException, IOException {
            Pattern versionPropertiesPattern = Pattern.compile(rootDir + "lib/versions/[^/]*\\.properties$");
            Enumeration<? extends ZipEntry> archiveEntries = archiveContainingProductInfos.entries();
            while (archiveEntries.hasMoreElements()) {
                ZipEntry entry = archiveEntries.nextElement();
                if (!versionPropertiesPattern.matcher(entry.getName()).matches()) continue;
                this._logger.log(Level.INFO, "Attempting to read product version info from {0}", entry.getName());
                InputStreamReader propertyReader = new InputStreamReader(archiveContainingProductInfos.getInputStream(entry));
                ProductInfo productInfo = ProductInfo.parseProductInfo((Reader)propertyReader, (File)archiveFile);
                this.infosList.add(productInfo);
                if (!"com.ibm.websphere.appserver".equals(productInfo.getId())) continue;
                this.websphereProductInfo = productInfo;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ProductRelatedParser$AssetInformation", AssetInformation.class, null, null);
        }
    }
}

