/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.reader.tasks;

import com.ibm.ws.security.audit.reader.AuditUtilityTask;
import com.ibm.ws.security.audit.reader.utils.CommandUtils;
import com.ibm.ws.security.audit.reader.utils.ConsoleWrapper;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;

public abstract class BaseCommandTask
implements AuditUtilityTask {
    public static final String NL = System.getProperty("line.separator");
    protected final String scriptName;

    public BaseCommandTask(String scriptName) {
        this.scriptName = scriptName;
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, boolean forceFormat, Object ... args) {
        return CommandUtils.getOption(key, forceFormat, args);
    }

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String getTaskHelp(String desc, String usage, String requiredKeyPrefix, String requiredDescPrefix, String optionKeyPrefix, String optionDescPrefix, String addonKey, String footer, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.usage", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.description", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, false, new Object[0]));
        scriptHelp.append(NL);
        String requireds = this.buildScriptOptions(requiredKeyPrefix, requiredDescPrefix);
        if (!requireds.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.required", false, new Object[0]));
            scriptHelp.append(requireds);
        }
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", false, new Object[0]));
            scriptHelp.append(options);
        }
        if (addonKey != null && !addonKey.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption(addonKey, false, new Object[0]));
        }
        if (footer != null && !footer.isEmpty()) {
            scriptHelp.append(footer);
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    protected String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        return value.toString();
    }

    protected String promptForPassword(ConsoleWrapper stdin, PrintStream stdout) {
        return this.promptForText(stdin, stdout, "password.enterText", "password.reenterText", "password.readError", "password.entriesDidNotMatch");
    }

    protected String promptForText(ConsoleWrapper stdin, PrintStream stdout) {
        return this.promptForText(stdin, stdout, "encode.enterText", "encode.reenterText", "encode.readError", "encode.entriesDidNotMatch");
    }

    private String promptForText(ConsoleWrapper stdin, PrintStream stdout, String enterText, String reenterText, String readError, String entriesDidNotMatch) {
        String read1 = stdin.readMaskedText(this.getMessage(enterText, new Object[0]) + " ");
        String read2 = stdin.readMaskedText(this.getMessage(reenterText, new Object[0]) + " ");
        if (read1 == null && read2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (read1 == null || read2 == null) {
            stdout.println(this.getMessage(readError, new Object[0]));
            return this.promptForText(stdin, stdout, enterText, reenterText, readError, entriesDidNotMatch);
        }
        if (read1.equals(read2)) {
            return read1;
        }
        stdout.println(this.getMessage(entriesDidNotMatch, new Object[0]));
        return this.promptForText(stdin, stdout, enterText, reenterText, readError, entriesDidNotMatch);
    }

    protected String getArgumentValue(String arg, String[] args, String defalt, String passwordArgKey, ConsoleWrapper stdin, PrintStream stdout) {
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0];
            if (!key.equals(arg)) continue;
            String value = this.getValue(args[i]);
            if (arg.equals(passwordArgKey) && value == null) {
                return this.promptForPassword(stdin, stdout);
            }
            return value;
        }
        return defalt;
    }

    abstract boolean isKnownArgument(String var1);

    abstract void checkRequiredArguments(String[] var1) throws IllegalArgumentException;

    protected void validateArgumentList(String[] args, List<String> keyOnlyArgs) {
        this.checkRequiredArguments(args);
        for (int i = 1; i < args.length; ++i) {
            String argPair = args[i];
            String arg = null;
            String value = null;
            if (argPair.contains("=")) {
                arg = argPair.split("=")[0];
                value = this.getValue(argPair);
            } else {
                arg = argPair;
            }
            if (!this.isKnownArgument(arg)) {
                throw new IllegalArgumentException(this.getMessage("invalidArg", arg));
            }
            if (keyOnlyArgs.contains(arg) || value != null) continue;
            throw new IllegalArgumentException(this.getMessage("missingValue", arg));
        }
    }
}

