/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryProxy
extends SSLSocketFactory {
    private SSLSocketFactory factory = null;
    private static SSLSocketFactoryProxy thisClass = null;
    private static volatile Class<SSLSocketFactory> theFactoryClass = null;

    public SSLSocketFactoryProxy() {
        Class<SSLSocketFactory> theClazz = theFactoryClass;
        if (theClazz == null) {
            throw new RuntimeException("No factory set.");
        }
        try {
            this.factory = theClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        thisClass = new SSLSocketFactoryProxy();
        return thisClass;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        String[] output = null;
        if (this.factory != null) {
            output = this.factory.getDefaultCipherSuites();
        }
        return output;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String[] output = null;
        if (this.factory != null) {
            output = this.factory.getSupportedCipherSuites();
        }
        return output;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.factory.createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, localHost, localPort);
    }
}

