/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.buffer;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleRotatingQueue<T>
implements Queue<T> {
    private final T[] elements;
    private final AtomicInteger tailIndex = new AtomicInteger(0);

    public SimpleRotatingQueue(T[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("elements array must not be null or zero-length");
        }
        this.elements = elements;
    }

    @Override
    public boolean add(T element) {
        this.elements[this.getAndUpdateTail()] = element;
        return true;
    }

    private int getAndUpdateTail() {
        int retMe;
        while (!this.tailIndex.compareAndSet(retMe = this.tailIndex.get(), this.getNext(retMe))) {
        }
        return retMe;
    }

    private int getNext(int index) {
        return ++index == this.elements.length ? 0 : index;
    }

    @Override
    public <X> X[] toArray(X[] arr) {
        int currTailIndex;
        if (arr == null) {
            return null;
        }
        X[] retMe = arr.length >= this.elements.length ? arr : (Object[])Array.newInstance(arr.getClass().getComponentType(), this.elements.length);
        do {
            currTailIndex = this.tailIndex.get();
            int firstCopyLen = this.elements.length - currTailIndex;
            System.arraycopy(this.elements, currTailIndex, retMe, 0, firstCopyLen);
            System.arraycopy(this.elements, 0, retMe, firstCopyLen, currTailIndex);
        } while (!this.tailIndex.compareAndSet(currTailIndex, currTailIndex));
        return retMe;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((X[])new Object[0]);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }
}

