/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object.hpel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public class RemoteRepositoryCache
implements Serializable {
    private static final long serialVersionUID = -8618080841198449905L;
    private final int total;
    private final byte[][] start;
    private final byte[][] end;
    transient int size = -1;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = -1;
    }

    public RemoteRepositoryCache(int total, byte[][] start, byte[][] end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Neither start nor end value can be 'null'");
        }
        if (total < start.length + end.length) {
            throw new IllegalArgumentException("Value of total should be more or equal to sum of start and end array sizes.");
        }
        this.total = total;
        this.start = start;
        this.end = end;
    }

    public int getTotal() {
        return this.total;
    }

    public byte[][] getStart() {
        return this.start;
    }

    public byte[][] getEnd() {
        return this.end;
    }

    public boolean isComplete() {
        return this.total == this.start.length + this.end.length;
    }

    public int getSize() {
        if (this.size < 0) {
            this.size = 0;
            for (byte[] cache : this.start) {
                this.size += new RemoteOneFileCache(cache).getSize();
            }
            for (byte[] cache : this.end) {
                this.size += new RemoteOneFileCache(cache).getSize();
            }
        }
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.end);
        result = 31 * result + Arrays.hashCode((Object[])this.start);
        result = 31 * result + this.total;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteRepositoryCache other = (RemoteRepositoryCache)obj;
        if (!Arrays.deepEquals((Object[])this.end, (Object[])other.end)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.start, (Object[])other.start)) {
            return false;
        }
        return this.total == other.total;
    }

    public static class RemoteOneFileCache {
        private final long timestamp;
        private final int size;
        private final long firstId;
        private final long lastId;

        public RemoteOneFileCache(long timestamp, int size, long firstId, long lastId) {
            this.timestamp = timestamp;
            this.size = size;
            this.firstId = firstId;
            this.lastId = lastId;
        }

        public RemoteOneFileCache(byte[] cache) {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(cache));
            try {
                this.timestamp = input.readLong();
                this.size = input.readInt();
                this.firstId = input.readLong();
                this.lastId = input.readLong();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Input bytes do not contain all necessary values");
            }
        }

        public byte[] toByteArray() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(28);
            try {
                DataOutputStream output = new DataOutputStream(buffer);
                output.writeLong(this.timestamp);
                output.writeInt(this.size);
                output.writeLong(this.firstId);
                output.writeLong(this.lastId);
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Internal Error: failed to write into in-memory buffer");
            }
            return buffer.toByteArray();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getSize() {
            return this.size;
        }

        public long getFirstId() {
            return this.firstId;
        }

        public long getLastId() {
            return this.lastId;
        }
    }
}

