/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.impl.AbstractBufferedLogFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class LogFileWriterImpl
extends AbstractBufferedLogFileWriter {
    private long total = 0L;

    public LogFileWriterImpl(File file, boolean bufferingEnabled) throws IOException {
        super(file, bufferingEnabled);
    }

    @Override
    public void close(byte[] tail) throws IOException {
        if (tail != null) {
            this.write(tail);
        }
        super.close(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        byte[] buffer = new byte[b.length + 8];
        this.writeLength(b.length, buffer, 0);
        System.arraycopy(b, 0, buffer, 4, b.length);
        this.writeLength(b.length, buffer, b.length + 4);
        OutputStream outputStream = this.fileStream;
        synchronized (outputStream) {
            this.fileStream.write(buffer);
        }
        this.total += (long)buffer.length;
    }

    @Override
    public long checkTotal(byte[] buffer, byte[] tail) {
        return this.total + (long)buffer.length + (long)tail.length + 16L;
    }

    private void writeLength(int value, byte[] buffer, int offset) throws IOException {
        buffer[offset + 3] = (byte)(value >>> 0);
        buffer[offset + 2] = (byte)(value >>> 8);
        buffer[offset + 1] = (byte)(value >>> 16);
        buffer[offset] = (byte)(value >>> 24);
    }
}

