/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.handlers;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.writer.LogEventNotifier;
import com.ibm.ws.logging.hpel.LogFileWriter;
import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositorySubProcessCommunication;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.handlers.LogRecordHandler;
import com.ibm.ws.logging.hpel.handlers.LogRecordTextHandler;
import com.ibm.ws.logging.hpel.impl.LogFileWriterTextImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerTextImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositorySpaceAlert;
import com.ibm.ws.logging.hpel.impl.LogRepositorySubManagerImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterCBuffImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterImpl;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class LogRepositoryComponent {
    private static LogRecordHandler binaryHandler = null;
    private static LogRecordTextHandler textHandler = null;
    private static String svPid;
    private static String svSuperPid;
    private static String svLabel;
    public static final int TRACE_THRESHOLD = 625;
    private static final BinaryDestinationChanger LOG_DESTINATION_CHANGER;
    private static final BinaryDestinationChanger TRACE_DESTINATION_CHANGER;
    private static final DestinationChanger TEXT_DESTINATION_CHANGER;

    private static synchronized LogRecordHandler getBinaryHandler() {
        if (binaryHandler == null) {
            binaryHandler = new LogRecordHandler(625, LogRepositoryManagerImpl.KNOWN_FORMATTERS[0]);
        }
        return binaryHandler;
    }

    public static boolean removeFiles(String destinationType) {
        LogRepositoryManager destManager = LogRepositoryComponent.getManager(destinationType);
        if (destManager instanceof LogRepositoryManagerImpl) {
            return destManager.purgeOldFiles();
        }
        return false;
    }

    public static void setLogEventNotifier(LogEventNotifier logEventNotifier) {
        LogRepositoryManager destManager = LogRepositoryComponent.getManager("trace");
        destManager.setLogEventNotifier(logEventNotifier);
        destManager = LogRepositoryComponent.getManager("log");
        destManager.setLogEventNotifier(logEventNotifier);
    }

    public static void setNotificationAgent(LogRepositorySubProcessCommunication commAgent) {
        if (svSuperPid != null) {
            LogRepositoryManager destManager = LogRepositoryComponent.getManager("trace");
            ((LogRepositorySubManagerImpl)destManager).setSubProcessCommunicationAgent(commAgent);
            destManager = LogRepositoryComponent.getManager("log");
            ((LogRepositorySubManagerImpl)destManager).setSubProcessCommunicationAgent(commAgent);
        }
    }

    public static String addRemoteProcessFile(String destinationType, long spTimeStamp, String spPid, String spLabel) {
        LogRepositoryManager destManager = LogRepositoryComponent.getManager(destinationType);
        String subProcessFileName = null;
        if (destManager instanceof LogRepositoryManagerImpl) {
            subProcessFileName = ((LogRepositoryManagerImpl)destManager).addNewFileFromSubProcess(spTimeStamp, spPid, spLabel);
        }
        return subProcessFileName;
    }

    public static void inactivateSubProcess(String spPid) {
        LogRepositoryManager destManager = LogRepositoryComponent.getManager("trace");
        ((LogRepositoryManagerImpl)destManager).inactivateSubProcess(spPid);
        destManager = LogRepositoryComponent.getManager("log");
        ((LogRepositoryManagerImpl)destManager).inactivateSubProcess(spPid);
    }

    private static LogRepositoryManager getManager(String destinationType) {
        DestinationChanger destinationChanger = LogRepositoryComponent.getDestination(destinationType);
        if (destinationChanger == null) {
            return null;
        }
        LogRepositoryWriter destWriter = destinationChanger.getWriter();
        return destWriter.getLogRepositoryManager();
    }

    private static DestinationChanger getDestination(String destinationType) {
        String lowType = destinationType.toLowerCase();
        if ("trace".equals(lowType)) {
            return TRACE_DESTINATION_CHANGER;
        }
        if ("log".equals(lowType)) {
            return LOG_DESTINATION_CHANGER;
        }
        if ("textlog".equals(lowType)) {
            return TEXT_DESTINATION_CHANGER;
        }
        return null;
    }

    public static synchronized void setLogDirectoryDestination(String location, boolean enablePurgeBySize, boolean enablePurgeByTime, boolean enableFileSwitch, boolean enableBuffering, long maxRepositorySize, long retentionTime, int fileSwitchHour, String outOfSpaceAction) {
        LOG_DESTINATION_CHANGER.setDirectoryDestination(location, enablePurgeBySize, enablePurgeByTime, enableFileSwitch, enableBuffering, maxRepositorySize, retentionTime, fileSwitchHour, outOfSpaceAction, "log");
    }

    public static synchronized void setTraceDirectoryDestination(String location, boolean enablePurgeBySize, boolean enablePurgeByTime, boolean enableFileSwitch, boolean enableBuffering, long maxRepositorySize, long retentionTime, int fileSwitchHour, String outOfSpaceAction) {
        TRACE_DESTINATION_CHANGER.setDirectoryDestination(location, enablePurgeBySize, enablePurgeByTime, enableFileSwitch, enableBuffering, maxRepositorySize, retentionTime, fileSwitchHour, outOfSpaceAction, "trace");
    }

    public static synchronized void setLogStreamDestination(String location) {
        LOG_DESTINATION_CHANGER.setStreamDestination(location);
    }

    public static synchronized void setTraceStreamDestination(String location) {
        TRACE_DESTINATION_CHANGER.setStreamDestination(location);
    }

    public static synchronized void start() {
        Logger.getLogger("").addHandler(LogRepositoryComponent.getBinaryHandler());
    }

    public static synchronized void setTraceMemoryDestination(String location, long maxSize) {
        LogRepositoryManager oldManager;
        LogRepositoryWriterCBuffImpl writer;
        LogRepositoryWriter old = LogRepositoryComponent.getBinaryHandler().getTraceWriter();
        if (location == null && old instanceof LogRepositoryWriterCBuffImpl) {
            writer = (LogRepositoryWriterCBuffImpl)old;
        } else {
            LogRepositoryManager manager = null;
            if (location == null && old != null) {
                manager = old.getLogRepositoryManager();
            } else if (location != null) {
                manager = svSuperPid != null ? new LogRepositorySubManagerImpl(new File(location, "tracedata"), svPid, svLabel, svSuperPid) : new LogRepositoryManagerImpl(new File(location, "tracedata"), svPid, svLabel, true);
            }
            if (manager == null) {
                throw new IllegalArgumentException("Argument 'location' can't be null if log writer was not setup by this class.");
            }
            writer = new LogRepositoryWriterCBuffImpl(new LogRepositoryWriterImpl(manager));
        }
        if (maxSize <= 0L) {
            if (old != writer) {
                writer.stop();
            }
            throw new IllegalArgumentException("Argument 'maxSize' should be more than zero");
        }
        writer.setMaxSize(maxSize);
        if (old != null && (oldManager = old.getLogRepositoryManager()) != null && oldManager != writer.getLogRepositoryManager()) {
            if (old != writer) {
                old.stop();
            }
            oldManager.stop();
        }
        LogRepositoryComponent.getBinaryHandler().setTraceWriter(writer);
    }

    public static synchronized void dumpTraceMemory() {
        LogRepositoryWriter writer = LogRepositoryComponent.getBinaryHandler().getTraceWriter();
        if (writer instanceof LogRepositoryWriterCBuffImpl) {
            ((LogRepositoryWriterCBuffImpl)writer).dumpItems();
        }
    }

    public static synchronized void setTextDestination(String location, boolean enablePurgeBySize, boolean enablePurgeByTime, boolean enableFileSwitch, boolean enableBuffering, long maxRepositorySize, long retentionTime, int fileSwitchHour, String outOfSpaceAction, String outputFormat, boolean includeTrace) {
        if (svSuperPid != null) {
            return;
        }
        if (location == null && textHandler == null) {
            throw new IllegalArgumentException("Argument 'location' can't be null if text logging is not enabled.");
        }
        HpelFormatter.getFormatter(outputFormat);
        boolean addedHere = false;
        if (textHandler == null) {
            textHandler = new LogRecordTextHandler(625);
            Logger.getLogger("").addHandler(textHandler);
            addedHere = true;
        }
        try {
            TEXT_DESTINATION_CHANGER.setDirectoryDestination(location, enablePurgeBySize, enablePurgeByTime, enableFileSwitch, enableBuffering, maxRepositorySize, retentionTime, fileSwitchHour, outOfSpaceAction, "textlog");
        }
        catch (RuntimeException ex) {
            if (addedHere) {
                LogRepositoryComponent.disableTextDestination();
            }
            throw ex;
        }
        textHandler.setFormat(outputFormat);
        textHandler.setIncludeTrace(includeTrace);
    }

    public static synchronized void disableTextDestination() {
        if (textHandler != null) {
            Logger.getLogger("").removeHandler(textHandler);
            textHandler.stop();
            textHandler = null;
        }
    }

    public static void setProcessInfo(String pid, String label, String superPid) {
        svPid = pid;
        svLabel = label;
        svSuperPid = superPid;
    }

    public static synchronized void stop() {
        if (svSuperPid != null) {
            LogRepositoryManager destManager = LogRepositoryComponent.getManager("log");
            ((LogRepositorySubManagerImpl)destManager).inactivateSubProcess();
        }
        Logger manager = Logger.getLogger("");
        if (binaryHandler != null) {
            manager.removeHandler(binaryHandler);
            binaryHandler.stop();
            binaryHandler = null;
        }
        if (textHandler != null) {
            manager.removeHandler(textHandler);
            textHandler.stop();
            textHandler = null;
        }
        LogRepositorySpaceAlert.getInstance().stop();
    }

    static {
        svSuperPid = null;
        LOG_DESTINATION_CHANGER = new BinaryDestinationChanger(){

            @Override
            protected LogRepositoryWriter getWriter() {
                return LogRepositoryComponent.getBinaryHandler().getLogWriter();
            }

            @Override
            protected void setWriter(LogRepositoryWriter writer) {
                LogRepositoryComponent.getBinaryHandler().setLogWriter(writer);
            }

            @Override
            protected String getDirName() {
                return "logdata";
            }
        };
        TRACE_DESTINATION_CHANGER = new BinaryDestinationChanger(){

            @Override
            protected LogRepositoryWriter getWriter() {
                return LogRepositoryComponent.getBinaryHandler().getTraceWriter();
            }

            @Override
            protected void setWriter(LogRepositoryWriter writer) {
                LogRepositoryComponent.getBinaryHandler().setTraceWriter(writer);
            }

            @Override
            protected String getDirName() {
                return "tracedata";
            }
        };
        TEXT_DESTINATION_CHANGER = new DestinationChanger(){

            @Override
            protected LogRepositoryManager createNewManager(String location, String managedType) {
                LogRepositoryManagerTextImpl logRepositoryManager = new LogRepositoryManagerTextImpl(new File(location), svPid, svLabel, false);
                logRepositoryManager.setManagedType(managedType);
                return logRepositoryManager;
            }

            @Override
            protected LogRepositoryWriterImpl createNewWriter(LogRepositoryManager manager) {
                return new LogRepositoryWriterImpl(manager){

                    @Override
                    protected LogFileWriter createNewWriter(File file) throws IOException {
                        return new LogFileWriterTextImpl(file, this.bufferingEnabled);
                    }
                };
            }

            @Override
            protected void testWriter(LogRepositoryWriterImpl writer) {
                textHandler.copyHeader(writer);
                try {
                    writer.writeHeader(System.currentTimeMillis());
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Failed to write header into destination file", ex);
                }
            }

            @Override
            protected LogRepositoryWriter getWriter() {
                return textHandler.getWriter();
            }

            @Override
            protected void setWriter(LogRepositoryWriter writer) {
                textHandler.setWriter(writer);
            }
        };
    }

    private static abstract class DestinationChanger {
        private DestinationChanger() {
        }

        protected abstract LogRepositoryWriter getWriter();

        protected abstract void setWriter(LogRepositoryWriter var1);

        protected abstract LogRepositoryWriterImpl createNewWriter(LogRepositoryManager var1);

        protected abstract LogRepositoryManager createNewManager(String var1, String var2);

        public void setDirectoryDestination(String location, boolean enablePurgeBySize, boolean enablePurgeByTime, boolean enableFileSwitch, boolean enableBuffering, long maxRepositorySize, long retentionTime, int fileSwitchHour, String outOfSpaceAction, String managedType) {
            LogRepositoryManager oldManager;
            LogRepositoryWriterImpl newWriter = null;
            LogRepositoryManager manager = null;
            if (location != null) {
                manager = this.createNewManager(location, managedType);
            } else {
                manager = this.getWriter().getLogRepositoryManager();
                if (manager == null) {
                    throw new IllegalArgumentException("Argument 'location' can't be null if log writer was not setup by this class.");
                }
                if (svSuperPid == null && !(manager instanceof LogRepositoryManagerImpl)) {
                    throw new IllegalArgumentException("The Manager in the writer is not expected LogRepositoryManagerImpl.");
                }
                if (svSuperPid != null && !(manager instanceof LogRepositorySubManagerImpl)) {
                    throw new IllegalArgumentException("The Manager in the writer is not expected LogRepositorySubManagerImpl.");
                }
            }
            newWriter = this.createNewWriter(manager);
            try {
                DestinationChanger.setOutOfSpaceAction(newWriter, outOfSpaceAction);
                newWriter.setBufferingEnabled(enableBuffering);
                if (enableFileSwitch) {
                    newWriter.enableFileSwitch(fileSwitchHour);
                } else {
                    newWriter.disableFileSwitch();
                }
                if (manager instanceof LogRepositoryManagerImpl) {
                    DestinationChanger.setRetention((LogRepositoryManagerImpl)manager, enablePurgeBySize, enablePurgeByTime, maxRepositorySize, retentionTime);
                } else {
                    ((LogRepositorySubManagerImpl)manager).configure(maxRepositorySize);
                }
                this.testWriter(newWriter);
            }
            catch (IllegalArgumentException ex) {
                newWriter.stop();
                throw ex;
            }
            LogRepositoryWriter oldWriter = this.getWriter();
            if (oldWriter != null && (oldManager = oldWriter.getLogRepositoryManager()) != null && oldManager != newWriter.getLogRepositoryManager()) {
                oldWriter.stop();
                oldManager.stop();
            }
            this.setWriter(newWriter);
        }

        protected void testWriter(LogRepositoryWriterImpl writer) throws IllegalArgumentException {
        }

        private static void setRetention(LogRepositoryManagerImpl manager, boolean enablePurgeBySize, boolean enablePurgeByTime, long maxRepositorySize, long retentionTime) {
            if (!enablePurgeBySize) {
                maxRepositorySize = -1L;
            }
            if (!enablePurgeByTime) {
                retentionTime = -1L;
            }
            manager.configure(maxRepositorySize, retentionTime);
        }

        private static void setOutOfSpaceAction(LogRepositoryWriterImpl writer, String type) {
            int value;
            if ("StopLogging".equalsIgnoreCase(type)) {
                value = 2;
            } else if ("PurgeOld".equalsIgnoreCase(type)) {
                value = 1;
            } else if ("StopServer".equalsIgnoreCase(type)) {
                value = 0;
            } else {
                throw new IllegalArgumentException("Unknown outOfSpaceAction value: " + type);
            }
            writer.setOutOfSpaceAction(value);
        }
    }

    private static abstract class BinaryDestinationChanger
    extends DestinationChanger {
        private BinaryDestinationChanger() {
        }

        protected abstract String getDirName();

        @Override
        protected LogRepositoryManager createNewManager(String location, String managedType) {
            LogRepositoryBaseImpl logRepositoryManager;
            if (svSuperPid != null) {
                logRepositoryManager = new LogRepositorySubManagerImpl(new File(location, this.getDirName()), svPid, svLabel, svSuperPid);
                logRepositoryManager.setManagedType(managedType);
            } else {
                logRepositoryManager = new LogRepositoryManagerImpl(new File(location, this.getDirName()), svPid, svLabel, true);
                logRepositoryManager.setManagedType(managedType);
            }
            return logRepositoryManager;
        }

        @Override
        protected LogRepositoryWriterImpl createNewWriter(LogRepositoryManager manager) {
            return new LogRepositoryWriterImpl(manager);
        }

        public void setStreamDestination(String location) {
        }
    }
}

