/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.ejs.ras.TrLevelConstants;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;

public class SafeTraceLevelIndexFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageIndex<Integer> createPackageIndex(String resourceName) {
        PackageIndex packageIndex = new PackageIndex();
        BufferedReader br = null;
        try {
            br = SafeTraceLevelIndexFactory.getLibertyTraceListReader(resourceName);
            SafeTraceLevelIndexFactory.addFiltersAndValuesToIndex(br, (PackageIndex<Integer>)packageIndex);
        }
        catch (IOException e) {
            System.err.println("Unable to load " + resourceName);
        }
        finally {
            SafeTraceLevelIndexFactory.tryToCloseReader(br);
        }
        packageIndex.compact();
        return packageIndex;
    }

    private static BufferedReader getLibertyTraceListReader(String resourceName) throws FileNotFoundException {
        InputStream traceListStream = TrConfigurator.class.getClassLoader().getResourceAsStream(resourceName);
        if (traceListStream == null) {
            traceListStream = new FileInputStream(resourceName);
        }
        return new BufferedReader(new InputStreamReader(traceListStream));
    }

    private static void addFiltersAndValuesToIndex(BufferedReader br, PackageIndex<Integer> packageIndex) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            int pos;
            if (line.isEmpty() || line.startsWith("#") || (pos = line.indexOf(61)) <= 0) continue;
            String filter = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            packageIndex.add(filter, (Object)SafeTraceLevelIndexFactory.getMinLevelIndex(value));
        }
    }

    private static Integer getMinLevelIndex(String value) {
        Integer minLevelIndex = 0;
        if ("info".equalsIgnoreCase(value)) {
            minLevelIndex = 6;
        } else {
            Level minLevel = Level.parse(value.toUpperCase());
            for (int i = 0; i < TrLevelConstants.levels.length; ++i) {
                if (!minLevel.equals(TrLevelConstants.levels[i])) continue;
                minLevelIndex = i;
                break;
            }
        }
        return minLevelIndex;
    }

    private static void tryToCloseReader(BufferedReader br) {
        if (br == null) {
            return;
        }
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

