/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class BurstDateFormat {
    private final DateTimeFormatter formatter;
    private final char millisecondSeparator;
    private final AtomicReference<CachedFormattedTime> cachedTime = new AtomicReference();
    volatile boolean invalidFormat = false;

    public BurstDateFormat(String formatPattern, char millisecondSeparator) {
        this(formatPattern, millisecondSeparator, Locale.getDefault(Locale.Category.FORMAT));
    }

    public BurstDateFormat(String formatPattern, char millisecondSeparator, Locale locale) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern(formatPattern);
        this.formatter = builder.toFormatter().withZone(ZoneId.systemDefault()).withLocale(locale).withChronology(Chronology.ofLocale(locale)).withDecimalStyle(DecimalStyle.of(locale));
        this.millisecondSeparator = millisecondSeparator;
        try {
            this.invalidFormat = formatPattern.lastIndexOf(83) - formatPattern.indexOf(83) != 2;
        }
        catch (Exception e) {
            this.invalidFormat = true;
        }
    }

    public String format(long timestamp) {
        if (this.invalidFormat) {
            return this.formatter.format(Instant.ofEpochMilli(timestamp));
        }
        try {
            long milliseconds = timestamp % 1000L;
            long timestampWithoutMillis = timestamp - milliseconds;
            CachedFormattedTime cachedFormattedTime = this.cachedTime.get();
            if (cachedFormattedTime == null || timestampWithoutMillis != cachedFormattedTime.refTimestampWithoutMillis) {
                String formattedDate = this.formatter.format(Instant.ofEpochMilli(timestamp));
                StringBuilder sb = new StringBuilder(4);
                sb.append(this.millisecondSeparator);
                if (milliseconds < 100L) {
                    if (milliseconds < 10L) {
                        sb.append("00");
                    } else {
                        sb.append('0');
                    }
                }
                sb.append(milliseconds);
                String millisecondString = sb.toString();
                int index = formattedDate.indexOf(millisecondString);
                if (index == -1) {
                    this.invalidFormat = true;
                    return formattedDate;
                }
                String refBeginning = formattedDate.substring(0, index + 1);
                String refEnding = formattedDate.substring(index + 4);
                this.cachedTime.compareAndSet(cachedFormattedTime, new CachedFormattedTime(timestampWithoutMillis, refBeginning, refEnding));
                return formattedDate;
            }
            StringBuilder sb = new StringBuilder(cachedFormattedTime.refBeginning);
            if (milliseconds < 100L) {
                if (milliseconds < 10L) {
                    sb.append("00");
                } else {
                    sb.append('0');
                }
            }
            sb.append(milliseconds).append(cachedFormattedTime.refEnding);
            return sb.toString();
        }
        catch (Exception e) {
            this.invalidFormat = true;
            return this.formatter.format(Instant.ofEpochMilli(timestamp));
        }
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.formatter;
    }

    private static class CachedFormattedTime {
        final long refTimestampWithoutMillis;
        final String refBeginning;
        final String refEnding;

        CachedFormattedTime(long refTimestampWithoutMillis, String refBeginning, String refEnding) {
            this.refTimestampWithoutMillis = refTimestampWithoutMillis;
            this.refBeginning = refBeginning;
            this.refEnding = refEnding;
        }
    }
}

