/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.jmx.internal;

import com.ibm.ws.kernel.boot.jmx.service.DelayedMBeanHelper;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerNotificationSupport;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;

final class PlatformMBeanServerDelegate
extends MBeanServerDelegate
implements MBeanServerNotificationSupport {
    protected static final String MBEANSERVER_ID = "WebSphere";
    private static final AtomicInteger count = new AtomicInteger(0);
    private final String id;
    private final CopyOnWriteArraySet<DelayedMBeanHelper> delayedMBeanHelpers = new CopyOnWriteArraySet();

    public PlatformMBeanServerDelegate() {
        int currentCount = count.getAndIncrement();
        if (currentCount > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(MBEANSERVER_ID);
            sb.append('_');
            sb.append(currentCount);
            this.id = sb.toString();
        } else {
            this.id = MBEANSERVER_ID;
        }
    }

    void addDelayedMBeanHelper(DelayedMBeanHelper helper) {
        this.delayedMBeanHelpers.add(helper);
    }

    void removeDelayedMBeanHelper(DelayedMBeanHelper helper) {
        this.delayedMBeanHelpers.remove(helper);
    }

    @Override
    public String getMBeanServerId() {
        return this.id;
    }

    @Override
    public void sendNotification(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            if ("JMX.mbean.registered".equals(notification.getType())) {
                for (DelayedMBeanHelper helper : this.delayedMBeanHelpers) {
                    if (helper == null || !helper.isDelayedMBean(mBeanServerNotification.getMBeanName())) continue;
                    return;
                }
            }
        }
        super.sendNotification(notification);
    }

    @Override
    public void sendRegisterNotification(ObjectName objectName) {
        this.sendNotificationInternal("JMX.mbean.registered", objectName);
    }

    @Override
    public void sendUnregisterNotification(ObjectName objectName) {
        this.sendNotificationInternal("JMX.mbean.unregistered", objectName);
    }

    private void sendNotificationInternal(String type, ObjectName objectName) {
        super.sendNotification(new MBeanServerNotification(type, (Object)MBeanServerDelegate.DELEGATE_NAME, 0L, objectName));
    }
}

