/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.commands.DumpProcessor;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.ProcessControlHelper;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;

public class ServerDumpPackager {
    final String serverName;
    final String serverOutputDir;
    final BootstrapConfig bootProps;
    final String dumpTimestamp;
    File dumpDir = null;
    File archive = null;

    public ServerDumpPackager(BootstrapConfig bootProps) {
        this(bootProps, null);
    }

    public ServerDumpPackager(BootstrapConfig bootProps, String packageFileName) {
        this.serverName = bootProps.getProcessName();
        this.bootProps = bootProps;
        this.serverOutputDir = bootProps.get("server.output.dir");
        SimpleDateFormat sdf = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
        this.dumpTimestamp = sdf.format(new Date());
        if (packageFileName == null || packageFileName.isEmpty()) {
            packageFileName = this.serverName + ".dump-" + this.dumpTimestamp + ".zip";
            this.archive = new File(this.serverOutputDir, packageFileName);
        } else {
            this.archive = new File(packageFileName);
            if (!this.archive.isAbsolute()) {
                this.archive = new File(this.serverOutputDir, packageFileName);
            }
        }
    }

    public void initializeDumpDirectory() {
        if (this.dumpDir == null) {
            this.dumpDir = new File(this.serverOutputDir, "dump_" + this.dumpTimestamp);
            if (!FileUtils.createDir(this.dumpDir)) {
                throw new IllegalStateException("Dump directory could not be created.");
            }
            this.dumpDir.setReadable(true, false);
            this.dumpDir.setWritable(true, false);
            this.dumpDir.setExecutable(true, false);
        }
    }

    public void cleanupDumpDirectory() {
        if (this.dumpDir != null) {
            FileUtils.recursiveClean(this.dumpDir);
            this.dumpDir = null;
        }
    }

    public File getDumpFile() {
        return this.archive;
    }

    public File getDumpDir() {
        return this.dumpDir;
    }

    public String getDumpTimestamp() {
        return this.dumpTimestamp;
    }

    public ReturnCode packageDump(boolean javaDumpsRequested) {
        File autoPdZip = new File(this.serverOutputDir, "autopdzip");
        File autoPd = new File(autoPdZip, "autopd/autopd-collection-environment-v2.xml");
        if (autoPd.getParentFile().mkdirs()) {
            try {
                FileUtils.createFile(autoPd, this.getClass().getResourceAsStream("/OSGI-OPT/websphere/autopd-collection-environment-v2.xml"));
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
        }
        this.captureEnvData(this.dumpDir, this.bootProps.getInstallRoot());
        File libInventory = new File(this.dumpDir, "library-inventory.txt");
        if (!new FolderStructureGenerator().generate(this.bootProps.getInstallRoot(), libInventory)) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.LibInventoryGenerationException"), this.serverName));
        }
        ArrayList<String> javaDumps = new ArrayList<String>();
        if (javaDumpsRequested) {
            File javaDumpLocationFile = new File(this.dumpDir + File.separator + ".dumpedjava");
            Map<JavaDumpAction, String> javaDumpLocations = ProcessControlHelper.readJavaDumpLocations(javaDumpLocationFile);
            if (javaDumpLocations == null) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.fileNotFound"), javaDumpLocationFile.getAbsolutePath()));
            } else {
                String javacoreName;
                javaDumps.addAll(javaDumpLocations.values());
                javaDumps.remove("");
                if (ServerDumpUtil.isZos() && Charset.isSupported("IBM-1047") && (javacoreName = javaDumpLocations.get((Object)JavaDumpAction.THREAD)) != null && !javacoreName.equals("")) {
                    try {
                        int readInt;
                        File javacoreEbcdic = new File(javacoreName);
                        File javacoreAscii = new File(javacoreEbcdic.getAbsolutePath() + ".tmp");
                        javacoreAscii.createNewFile();
                        javacoreAscii.setWritable(true);
                        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(javacoreEbcdic), Charset.forName("IBM-1047"));
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(javacoreAscii), StandardCharsets.US_ASCII);
                        while ((readInt = reader.read()) != -1) {
                            writer.write(readInt);
                        }
                        reader.close();
                        writer.close();
                        if (javacoreAscii.exists()) {
                            javacoreEbcdic.delete();
                            javacoreAscii.renameTo(javacoreEbcdic);
                        }
                    }
                    catch (IOException e) {
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.cannotConvertEbcdicToAscii"), javacoreName));
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        ReturnCode rc = this.packageServerDumps(this.archive, javaDumps);
        if (!javaDumps.isEmpty()) {
            for (String f : javaDumps) {
                File file = new File(f);
                file.delete();
            }
        }
        FileUtils.recursiveClean(autoPdZip);
        return rc;
    }

    private void captureEnvData(File dumpDir, File installDir) {
        File versionsSource = new File(installDir, "lib/versions");
        File fixesSource = new File(installDir, "lib/fixes");
        String sharedConfigDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("shared.config.dir");
            }
        });
        File sharedConfigSource = sharedConfigDir != null ? new File(sharedConfigDir) : new File(installDir, "usr/shared/config");
        File versionsTarget = new File(dumpDir, "service/versions");
        File fixesTarget = new File(dumpDir, "service/fixes");
        File sharedConfigTarget = new File(dumpDir, "usr/shared/config");
        if (versionsTarget.mkdirs()) {
            try {
                FileUtils.copyDir(versionsSource, versionsTarget);
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
        }
        if (fixesTarget.mkdirs()) {
            try {
                FileUtils.copyDir(fixesSource, fixesTarget);
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
        }
        if (sharedConfigTarget.mkdirs()) {
            try {
                FileUtils.copyDir(sharedConfigSource, sharedConfigTarget);
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private ReturnCode packageServerDumps(File packageFile, List<String> javaDumps) {
        DumpProcessor processor = new DumpProcessor(this.serverName, packageFile, this.bootProps, javaDumps);
        return processor.execute();
    }

    static class FolderStructureGenerator {
        private static final int NUM_MD5_BYTES = 16;
        private final MessageDigest md5 = FolderStructureGenerator.newMD5MessageDigest();
        private final byte[] md5Bytes = new byte[16384];
        private final char[] md5Chars = new char[32];

        FolderStructureGenerator() {
        }

        protected static MessageDigest newMD5MessageDigest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (Exception ex) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean generate(File folder, File output) {
            if (folder == null || output == null) {
                return false;
            }
            if (!folder.exists() || !folder.isDirectory()) {
                return false;
            }
            BufferedWriter writer = null;
            try {
                FileOutputStream outputStream = TextFileOutputStreamFactory.createOutputStream(output);
                writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                Formatter formatter = new Formatter(writer);
                this.printFileList(folder, formatter, folder.getAbsolutePath().length() + 1);
                Utils.tryToClose(writer);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                Utils.tryToClose(writer);
            }
            return true;
        }

        void printFileList(File targetDir, Formatter writer, int leadingPathLength) throws IOException {
            File[] contents = targetDir.listFiles();
            if (contents != null) {
                List<File> contentList = Arrays.asList(contents);
                Collections.sort(contentList);
                for (File file : contentList) {
                    String fileName = file.getAbsolutePath().substring(leadingPathLength);
                    if (file.isDirectory()) {
                        writer.format("d  %1$10s  %2$tF %2$tT  %3$32s  %4$s%n", "", file.lastModified(), "", fileName + File.separator);
                        if ("usr".equals(file.getName())) continue;
                        this.printFileList(file, writer, leadingPathLength);
                        continue;
                    }
                    writer.format("f  %1$10d  %2$tF %2$tT  %3$32s  %4$s%n", file.length(), file.lastModified(), this.md5(file), fileName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String md5(File file) {
            if (this.md5 == null) {
                return "MD5 unavailable";
            }
            InputStream in = null;
            try {
                int read;
                in = new FileInputStream(file);
                in = new BufferedInputStream(in);
                while ((read = in.read(this.md5Bytes)) != -1) {
                    this.md5.update(this.md5Bytes, 0, read);
                }
            }
            catch (IOException ex) {
                String string;
                try {
                    string = ex.toString();
                }
                catch (Throwable throwable) {
                    Utils.tryToClose(in);
                    throw throwable;
                }
                Utils.tryToClose(in);
                return string;
            }
            Utils.tryToClose(in);
            byte[] bytes = this.md5.digest();
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                byte b = bytes[i];
                this.md5Chars[j++] = Character.forDigit(b >> 4 & 0xF, 16);
                this.md5Chars[j++] = Character.forDigit(b & 0xF, 16);
            }
            return new String(this.md5Chars);
        }
    }
}

