/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.common.crypto;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.service.util.JavaInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CryptoUtils {
    private static final String PROPERTY_USE_ENHANCED_SECURITY_ALG = "use.enhanced.security.algorithms";
    private static final TraceComponent tc = Tr.register(CryptoUtils.class);
    private static boolean issuedBetaMessage = false;
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA_128 = "SHA-128";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA128 = "SHA128";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA_256 = "SHA-256";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA256 = "SHA256";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA_384 = "SHA-384";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA384 = "SHA384";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA_512 = "SHA-512";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA512 = "SHA512";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA = "SHA";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA1 = "SHA1";
    public static final String MESSAGE_DIGEST_ALGORITHM_SHA_1 = "SHA-1";
    public static final String MESSAGE_DIGEST_ALGORITHM_MD5 = "MD5";
    public static boolean ibmJCEAvailable = false;
    public static boolean openJCEPlusAvailable = false;
    public static boolean ibmJCEProviderChecked = false;
    public static boolean openJCEPlusProviderChecked = false;
    public static boolean unitTest = false;
    public static boolean fipsChecked = false;
    public static boolean fips140_3Checked = false;
    public static boolean semeruFips140_3Checked = false;
    public static boolean ibmJdk8Fips140_3Checked = false;
    public static boolean isEnhancedSecurity = false;
    public static boolean isEnhancedSecurityChecked = false;
    public static boolean javaVersionChecked = false;
    public static boolean isJava11orHigher = false;
    public static boolean zOSAndJAVA11orHigherChecked = false;
    public static boolean iszOSAndJava11orHigher = false;
    public static String osName = System.getProperty("os.name");
    public static boolean isZOS = false;
    public static boolean osVersionChecked = false;
    public static String IBMJCE_PROVIDER = "com.ibm.crypto.provider.IBMJCE";
    public static String IBMJCE_PLUS_FIPS_PROVIDER = "com.ibm.crypto.plus.provider.IBMJCEPlusFIPS";
    public static String OPENJCE_PLUS_PROVIDER = "com.ibm.crypto.plus.provider.OpenJCEPlus";
    public static String OPENJCE_PLUS_FIPS_PROVIDER = "com.ibm.crypto.plus.provider.OpenJCEPlusFIPS";
    public static final String IBMJCE_NAME = "IBMJCE";
    public static final String IBMJCECCA_NAME = "IBMJCECCA";
    public static final String IBMJCE_PLUS_FIPS_NAME = "IBMJCEPlusFIPS";
    public static final String OPENJCE_PLUS_NAME = "OpenJCEPlus";
    public static final String OPENJCE_PLUS_FIPS_NAME = "OpenJCEPlusFIPS";
    public static final String USE_FIPS_PROVIDER = "com.ibm.jsse2.usefipsprovider";
    public static final String USE_FIPS_PROVIDER_NAME = "com.ibm.jsse2.usefipsProviderName";
    public static final String SIGNATURE_ALGORITHM_SHA1WITHRSA = "SHA1withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA256WITHRSA = "SHA256withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA512WITHRSA = "SHA512withRSA";
    public static final String RSA_SHA_512 = "RSA/SHA-512";
    public static final String RSA_SHA_1 = "RSA/SHA-1";
    public static final String CRYPTO_ALGORITHM_RSA = "RSA";
    public static final String SHA1PRNG = "SHA1PRNG";
    public static final String SHA256DRBG = "SHA256DRBG";
    public static final String HMACSHA1 = "HmacSHA1";
    public static final String ENCRYPT_ALGORITHM_DESEDE = "DESede";
    public static final String ENCRYPT_ALGORITHM_AES = "AES";
    public static final String ENCRYPT_MODE_ECB = "ECB";
    public static final String AES_GCM_CIPHER = "AES/GCM/NoPadding";
    public static final String DES_ECB_CIPHER = "DESede/ECB/PKCS5Padding";
    public static final String AES_CBC_CIPHER = "AES/CBC/PKCS5Padding";
    public static final int AES_128_KEY_LENGTH_BYTES = 16;
    public static final int AES_256_KEY_LENGTH_BYTES = 32;
    public static final int DESEDE_KEY_LENGTH_BYTES = 24;
    public static final int PBKDF2HMACSHA1_ITERATIONS = 84756;
    public static final int PBKDF2HMACSHA512_ITERATIONS = 210000;
    public static String SHA2DRBG = "SHA2DRBG";
    public static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    public static final String PBKDF2_WITH_HMAC_SHA512 = "PBKDF2WithHmacSHA512";
    public static final int FIPS1403_PBKDF2_MINIMUM_SALT_LENGTH_BYTES = 16;
    public static final int FIPS1403_PBKDF2_SALT_LENGTH_BYTES = 128;
    public static final int FIPS1403_PBKDF2_MINIMUM_KEY_LENGTH_BITS = 112;
    public static final int FIPS1403_PBKDF2_KEY_LENGTH_BITS = 256;
    public static final int FIPS1403_PBKDF2_MINIMUM_ITERATIONS = 1000;
    public static final int FIPS1403_PBKDF2_ITERATIONS = 210000;
    private static boolean ibmJdk8Fips140_3Enabled = CryptoUtils.isIbmJdk8Fips140_3Enabled();
    private static boolean semeruFips140_3Enabled = CryptoUtils.isSemeruFips140_3Enabled();
    private static boolean fips140_3Enabled;
    private static boolean fipsEnabled;
    public static final String ENCRYPT_ALGORITHM = "AES";
    public static final int AES_128_KEY_LENGTH_BITS = 128;
    public static final int AES_256_KEY_LENGTH_BITS = 256;
    private static Map<String, String> secureAlternative;
    public static final String MESSAGE_DIGEST_ALGORITHM;
    private static final List<String> supportedMessageDigestAlgorithms;

    public static boolean isAlgorithmInsecure(String algorithm) {
        return secureAlternative.containsKey(algorithm);
    }

    public static String getSecureAlternative(String algorithm) {
        return secureAlternative.get(algorithm);
    }

    public static String getSignatureAlgorithm() {
        if (fipsEnabled) {
            return SIGNATURE_ALGORITHM_SHA512WITHRSA;
        }
        return SIGNATURE_ALGORITHM_SHA1WITHRSA;
    }

    public static String getCipher() {
        return fipsEnabled ? AES_CBC_CIPHER : DES_ECB_CIPHER;
    }

    public static void logInsecureAlgorithm(String configProperty, String insecureAlgorithm) {
    }

    public static void logInsecureAlgorithmReplaced(String configProperty, String insecureAlgorithm, String secureAlgorithm) {
    }

    public static void logInsecureProvider(String provider, String insecureAlgorithm) {
    }

    public static boolean isIBMJCEAvailable() {
        if (ibmJCEProviderChecked) {
            return ibmJCEAvailable;
        }
        ibmJCEAvailable = JavaInfo.isSystemClassAvailable(IBMJCE_PROVIDER);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ibmJCEAvailable: " + ibmJCEAvailable), (Object[])new Object[0]);
        }
        ibmJCEProviderChecked = true;
        return ibmJCEAvailable;
    }

    public static boolean isOpenJCEPlusAvailable() {
        if (openJCEPlusProviderChecked) {
            return openJCEPlusAvailable;
        }
        openJCEPlusAvailable = JavaInfo.isSystemClassAvailable(OPENJCE_PLUS_PROVIDER);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("openJCEPlusAvailable: " + openJCEPlusAvailable), (Object[])new Object[0]);
        }
        openJCEPlusProviderChecked = true;
        return openJCEPlusAvailable;
    }

    private static boolean isJava11orHigher() {
        if (javaVersionChecked) {
            return isJava11orHigher;
        }
        isJava11orHigher = JavaInfo.majorVersion() >= 11;
        javaVersionChecked = true;
        return isJava11orHigher;
    }

    private static boolean isZOS() {
        if (osVersionChecked) {
            return isZOS;
        }
        isZOS = osName.equalsIgnoreCase("z/OS") || osName.equalsIgnoreCase("OS/390");
        osVersionChecked = true;
        return isZOS;
    }

    public static boolean isZOSandRunningJava11orHigher() {
        if (zOSAndJAVA11orHigherChecked) {
            return iszOSAndJava11orHigher;
        }
        iszOSAndJava11orHigher = CryptoUtils.isJava11orHigher() && CryptoUtils.isZOS();
        zOSAndJAVA11orHigherChecked = true;
        return iszOSAndJava11orHigher;
    }

    public static String getProvider() {
        String provider = null;
        if (fipsEnabled && !CryptoUtils.useEnhancedSecurityAlgorithms()) {
            provider = CryptoUtils.isSemeruFips() ? OPENJCE_PLUS_FIPS_NAME : IBMJCE_PLUS_FIPS_NAME;
        } else if (CryptoUtils.isZOSandRunningJava11orHigher() && CryptoUtils.isOpenJCEPlusAvailable()) {
            provider = OPENJCE_PLUS_NAME;
        } else if (CryptoUtils.isIBMJCEAvailable()) {
            provider = IBMJCE_NAME;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (provider != null) {
                Tr.debug((TraceComponent)tc, (String)("Provider configured is " + provider), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Provider configured by JDK is " + (Security.getProviders() != null ? Security.getProviders()[0].getName() : "NULL")), (Object[])new Object[0]);
            }
        }
        return provider;
    }

    public static String getMessageDigestAlgorithm() {
        return MESSAGE_DIGEST_ALGORITHM_SHA256;
    }

    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return CryptoUtils.getMessageDigest(CryptoUtils.getMessageDigestAlgorithm());
    }

    public static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        if (!supportedMessageDigestAlgorithms.contains(algorithm)) {
            throw new NoSuchAlgorithmException(String.format("Algorithm %s is not supported", algorithm));
        }
        return MessageDigest.getInstance(algorithm);
    }

    public static MessageDigest getMessageDigestForLTPA() {
        MessageDigest md1 = null;
        try {
            md1 = fipsEnabled ? (CryptoUtils.useEnhancedSecurityAlgorithms() ? MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA_512) : (CryptoUtils.isSemeruFips() ? MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA_512, OPENJCE_PLUS_FIPS_NAME) : MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA_512, IBMJCE_PLUS_FIPS_NAME))) : (CryptoUtils.isIBMJCEAvailable() ? MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA, IBMJCE_NAME) : MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return md1;
    }

    public static String getPropertyLowerCase(final String prop, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(prop, defaultValue).toLowerCase();
            }
        });
    }

    static String getFipsLevel() {
        String result = CryptoUtils.getPropertyLowerCase("com.ibm.fips.mode", "disabled");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getFipsLevel: " + result), (Object[])new Object[0]);
        }
        return result;
    }

    public static boolean isIbmJdk8Fips140_3() {
        List<String> args = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        });
        return args.contains("-Xenablefips140-3");
    }

    public static boolean isSemeruFips() {
        return "true".equals(CryptoUtils.getPropertyLowerCase("semeru.fips", "false"));
    }

    protected static boolean useEnhancedSecurityAlgorithms() {
        if (isEnhancedSecurityChecked) {
            return isEnhancedSecurity;
        }
        boolean bl = isEnhancedSecurity = CryptoUtils.isRunningBetaMode() && Boolean.valueOf(CryptoUtils.getPropertyLowerCase(PROPERTY_USE_ENHANCED_SECURITY_ALG, "false")) != false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isEnhancedSecurity: " + (isEnhancedSecurity ? "enabled" : "disabled")), (Object[])new Object[0]);
        }
        isEnhancedSecurityChecked = true;
        return isEnhancedSecurity;
    }

    public static boolean isFips140_3EnabledWithBetaGuard() {
        return CryptoUtils.isRunningBetaMode() && CryptoUtils.isFips140_3Enabled();
    }

    private static boolean isSemeruFips140_3EnabledWithBetaGuard() {
        return CryptoUtils.isRunningBetaMode() && CryptoUtils.isSemeruFips140_3Enabled();
    }

    private static boolean isRunningBetaMode() {
        if (!ProductInfo.getBetaEdition()) {
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)"BETA: A beta method has been invoked for the class CryptoUtils for the first time.", (Object[])new Object[0]);
            issuedBetaMessage = true;
        }
        return true;
    }

    public static boolean isFips140_3Enabled() {
        if (fips140_3Checked) {
            return fips140_3Enabled;
        }
        boolean bl = fips140_3Enabled = CryptoUtils.isIbmJdk8Fips140_3Enabled() || CryptoUtils.isSemeruFips140_3Enabled();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFips140_3Enabled: " + fips140_3Enabled), (Object[])new Object[0]);
        }
        fips140_3Checked = true;
        return fips140_3Enabled;
    }

    static boolean isSemeruFips140_3Enabled() {
        if (semeruFips140_3Checked) {
            return semeruFips140_3Enabled;
        }
        semeruFips140_3Enabled = false;
        if (CryptoUtils.isSemeruFips() && "140-3".equals(CryptoUtils.getFipsLevel())) {
            if (CryptoUtils.isOpenJCEPlusFIPSProviderAvailable()) {
                semeruFips140_3Enabled = true;
                Tr.info((TraceComponent)tc, (String)"FIPS_140_3ENABLED", (Object[])new Object[]{OPENJCE_PLUS_FIPS_NAME});
            } else {
                Tr.error((TraceComponent)tc, (String)"FIPS_140_3ENABLED_ERROR", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSemeruFips140_3Enabled: " + semeruFips140_3Enabled), (Object[])new Object[0]);
        }
        if (!semeruFips140_3Enabled && (semeruFips140_3Enabled = CryptoUtils.useEnhancedSecurityAlgorithms()) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isSemeruFips140_3Enabled set to true by useEnhancedSecurityAlgorithms()", (Object[])new Object[0]);
        }
        semeruFips140_3Checked = true;
        return semeruFips140_3Enabled;
    }

    static boolean isIbmJdk8Fips140_3Enabled() {
        if (ibmJdk8Fips140_3Checked) {
            return ibmJdk8Fips140_3Enabled;
        }
        ibmJdk8Fips140_3Enabled = false;
        if (CryptoUtils.isIbmJdk8Fips140_3() && "140-3".equals(CryptoUtils.getFipsLevel())) {
            if (CryptoUtils.isIBMJCEPlusFIPSProviderAvailable()) {
                ibmJdk8Fips140_3Enabled = true;
                Tr.info((TraceComponent)tc, (String)"FIPS_140_3ENABLED", (Object[])new Object[]{IBMJCE_PLUS_FIPS_NAME});
            } else {
                Tr.error((TraceComponent)tc, (String)"FIPS_140_3ENABLED_ERROR", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isIbmJdk8Fips140_3Enabled: " + ibmJdk8Fips140_3Enabled), (Object[])new Object[0]);
        }
        if (!ibmJdk8Fips140_3Enabled && (ibmJdk8Fips140_3Enabled = CryptoUtils.useEnhancedSecurityAlgorithms()) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ibmJdk8Fips140_3Enabled set to true by useEnhancedSecurityAlgorithms()", (Object[])new Object[0]);
        }
        ibmJdk8Fips140_3Checked = true;
        return ibmJdk8Fips140_3Enabled;
    }

    public static boolean checkFipsCompatibleSalt(String saltString, boolean logIfIncompatible) {
        boolean isCompatible = true;
        if (CryptoUtils.isFips140_3EnabledWithBetaGuard() && saltString != null && !saltString.isEmpty() && saltString.length() < 16) {
            isCompatible = false;
        }
        if (!isCompatible && logIfIncompatible && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            try {
                throw new Exception("checkFipsCompatibleSalt failed!");
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Tr.debug((TraceComponent)tc, (String)("isCompatible: false, saltString: " + saltString + "\n" + sw.toString()), (Object[])new Object[0]);
            }
        }
        return isCompatible;
    }

    static boolean isIBMJCEPlusFIPSProviderAvailable() {
        return Security.getProvider(IBMJCE_PLUS_FIPS_NAME) != null;
    }

    static boolean isOpenJCEPlusFIPSProviderAvailable() {
        return Security.getProvider(OPENJCE_PLUS_FIPS_NAME) != null;
    }

    public static boolean isFips140_2Enabled() {
        boolean result;
        boolean bl = result = !CryptoUtils.isFips140_3Enabled() && "true".equals(CryptoUtils.getUseFipsProvider()) && IBMJCE_PLUS_FIPS_NAME.equalsIgnoreCase(CryptoUtils.getFipsProviderName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFips140_2Enabled: " + result), (Object[])new Object[0]);
        }
        return result;
    }

    static String getUseFipsProvider() {
        return CryptoUtils.getPropertyLowerCase(USE_FIPS_PROVIDER, "false");
    }

    static String getFipsProviderName() {
        return CryptoUtils.getPropertyLowerCase(USE_FIPS_PROVIDER_NAME, "NO_PROVIDER_NAME");
    }

    public static boolean isFIPSEnabled() {
        if (fipsChecked) {
            return fipsEnabled;
        }
        fipsEnabled = CryptoUtils.isFips140_3Enabled();
        fipsChecked = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFIPSEnabled: " + fipsEnabled), (Object[])new Object[0]);
        }
        return fipsEnabled;
    }

    public static byte[] generateRandomBytes(int length) {
        byte[] seed = null;
        SecureRandom rand = new SecureRandom();
        Provider provider = rand.getProvider();
        String providerName = provider.getName();
        if (providerName.equals(IBMJCECCA_NAME)) {
            seed = new byte[length];
            rand.nextBytes(seed);
        } else {
            seed = rand.generateSeed(length);
        }
        return seed;
    }

    public static int getPbkdf2Salt(int dflt) {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? 128 : dflt;
    }

    public static int getPbkdf2Iterations(int dflt) {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? 210000 : dflt;
    }

    public static int getPbkdf2KeyLength(int dflt) {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? 256 : dflt;
    }

    static {
        fipsEnabled = fips140_3Enabled = CryptoUtils.isFips140_3Enabled();
        secureAlternative = new HashMap<String, String>();
        secureAlternative.put(MESSAGE_DIGEST_ALGORITHM_SHA, MESSAGE_DIGEST_ALGORITHM_SHA256);
        secureAlternative.put(MESSAGE_DIGEST_ALGORITHM_SHA1, MESSAGE_DIGEST_ALGORITHM_SHA256);
        secureAlternative.put(MESSAGE_DIGEST_ALGORITHM_SHA_1, MESSAGE_DIGEST_ALGORITHM_SHA256);
        secureAlternative.put(MESSAGE_DIGEST_ALGORITHM_SHA128, MESSAGE_DIGEST_ALGORITHM_SHA256);
        secureAlternative.put(MESSAGE_DIGEST_ALGORITHM_MD5, MESSAGE_DIGEST_ALGORITHM_SHA256);
        MESSAGE_DIGEST_ALGORITHM = fipsEnabled ? MESSAGE_DIGEST_ALGORITHM_SHA256 : MESSAGE_DIGEST_ALGORITHM_SHA;
        supportedMessageDigestAlgorithms = Arrays.asList(MESSAGE_DIGEST_ALGORITHM_SHA256, MESSAGE_DIGEST_ALGORITHM_SHA_384, MESSAGE_DIGEST_ALGORITHM_SHA_512);
    }
}

