/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogRecordContext {
    private static final ThreadLocal<HashMap<String, String>> extensions = new ThreadLocal();
    private static final Map<String, WeakReference<Extension>> extensionMap = new ConcurrentHashMap<String, WeakReference<Extension>>();
    public static final String PTHREADID = "thread";
    private static final ThreadLocal<Boolean> recursion = new ThreadLocal();
    private static final Extension THREAD_NAME_EXTENSION = new Extension(){

        @Override
        public String getValue() {
            return Thread.currentThread().getName();
        }
    };

    public static void addExtension(String extensionName, String extensionValue) {
        if (extensionName == null || extensionValue == null) {
            throw new IllegalArgumentException("Neither 'extensionName' nor 'extensionValue' parameter can be null. Extension Name=" + extensionName + " Extension Value=" + extensionValue);
        }
        HashMap<String, String> ext = extensions.get();
        if (ext == null) {
            ext = new HashMap();
            extensions.set(ext);
        }
        ext.put(extensionName, extensionValue);
    }

    public static boolean removeExtension(String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter 'extensionName' can not be null");
        }
        HashMap<String, String> ext = extensions.get();
        return ext == null ? false : ext.remove(extensionName) != null;
    }

    public static void registerExtension(String key, Extension extension) {
        if (key == null || extension == null) {
            throw new IllegalArgumentException("Neither 'key' nor 'extension' parameter can be null.");
        }
        if (extensionMap.putIfAbsent(key, new WeakReference<Extension>(extension)) != null) {
            throw new IllegalArgumentException("Extension with the key " + key + " is registered already");
        }
    }

    public static boolean unregisterExtension(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 'key' can not be null");
        }
        return extensionMap.remove(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExtensions(Map<String, String> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("Parameter 'map' can not be null.");
        }
        if (recursion.get() == Boolean.TRUE) {
            return;
        }
        recursion.set(Boolean.TRUE);
        HashMap<String, WeakReference<Extension>> cleanup = new HashMap<String, WeakReference<Extension>>();
        try {
            for (Map.Entry<String, WeakReference<Extension>> entry : extensionMap.entrySet()) {
                WeakReference<Extension> value = entry.getValue();
                Extension extension = (Extension)value.get();
                if (extension == null) {
                    cleanup.put(entry.getKey(), value);
                    continue;
                }
                String extValue = extension.getValue();
                if (extValue == null) continue;
                map.put(entry.getKey(), extValue);
            }
        }
        finally {
            recursion.remove();
        }
        if (cleanup.size() > 0) {
            for (Map.Entry<String, WeakReference<Extension>> entry : cleanup.entrySet()) {
                extensionMap.remove(entry.getKey(), entry.getValue());
            }
        }
        if (extensions.get() != null) {
            for (Map.Entry<String, Object> entry : extensions.get().entrySet()) {
                map.put(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    static {
        extensionMap.put(PTHREADID, new WeakReference<Extension>(THREAD_NAME_EXTENSION));
    }

    public static interface Extension {
        public String getValue();
    }
}

