/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.model;

import com.ibm.ws.ras.instrument.internal.model.TraceType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class InstrumentationOptions {
    private List<Pattern> packagesInclude = new ArrayList<Pattern>();
    private List<Pattern> packagesExclude = new ArrayList<Pattern>();
    private boolean addFFDC = false;
    private TraceType traceType = TraceType.TR;

    public void addPackagesInclude(String regex) {
        Pattern pattern = Pattern.compile(regex);
        this.packagesInclude.add(pattern);
    }

    public void addPackagesExclude(String regex) {
        Pattern pattern = Pattern.compile(regex);
        this.packagesExclude.add(pattern);
    }

    public boolean isPackageIncluded(String internalPackageName) {
        if (this.packagesInclude.isEmpty() && this.packagesExclude.isEmpty()) {
            return !internalPackageName.startsWith("/java/lang");
        }
        String packageName = internalPackageName.replaceAll("/", "\\.");
        for (Pattern pi : this.packagesInclude) {
            if (!pi.matcher(packageName).matches()) continue;
            for (Pattern pe : this.packagesExclude) {
                if (!pe.matcher(packageName).matches()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean getAddFFDC() {
        return this.addFFDC;
    }

    public void setAddFFDC(boolean addFFDC) {
        this.addFFDC = addFFDC;
    }

    public void setTraceType(String traceType) {
        String string = traceType = traceType == null ? "" : traceType;
        this.traceType = traceType.equalsIgnoreCase("jsr47") || traceType.equalsIgnoreCase("java.util.logging") || traceType.equalsIgnoreCase("java_logging") ? TraceType.JAVA_LOGGING : (traceType.equalsIgnoreCase("tr") || traceType.equalsIgnoreCase("websphere") ? TraceType.TR : (traceType.equalsIgnoreCase("none") ? TraceType.NONE : TraceType.JAVA_LOGGING));
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";packagesInclude=").append(this.packagesInclude);
        sb.append(",packagesExclude=").append(this.packagesExclude);
        sb.append(",addFFDC=").append(this.addFFDC);
        sb.append(",traceType=").append((Object)this.traceType);
        return sb.toString();
    }
}

