/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.cmdline;

import com.ibm.ws.install.internal.cmdline.ExeAction;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExeHelpAction
implements ActionHandler {
    public static final String NL = System.getProperty("line.separator");
    public static final String COMMAND = "featureManager";
    public static final ResourceBundle options = ResourceBundle.getBundle("com.ibm.ws.kernel.feature.internal.resources.FeatureToolOptions");
    private static final ResourceBundle licenseOptions = ResourceBundle.getBundle("wlp.lib.extract.SelfExtractMessages");
    private static final Map<String, String> LICENSE_KEY_MAPPING = new HashMap<String, String>();

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(ExeHelpAction.getHelpPart("usage", COMMAND));
        scriptUsage.append(" {");
        ExeAction[] tasks = ExeAction.values();
        for (int i = 0; i < tasks.length; ++i) {
            ExeAction task = tasks[i];
            scriptUsage.append(task.toString());
            if (i == tasks.length - 1) continue;
            scriptUsage.append("|");
        }
        scriptUsage.append("} [");
        scriptUsage.append(ExeHelpAction.getHelpPart("global.options.lower", new Object[0]));
        scriptUsage.append("]");
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    public String getTaskUsage(ExeAction task) {
        StringBuilder taskUsage = new StringBuilder(NL);
        taskUsage.append(ExeHelpAction.getHelpPart("global.usage", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append('\t');
        taskUsage.append(COMMAND);
        taskUsage.append(' ');
        taskUsage.append((Object)task);
        taskUsage.append(" [");
        taskUsage.append(ExeHelpAction.getHelpPart("global.options.lower", new Object[0]));
        taskUsage.append("]");
        List<String> options = task.getCommandOptions();
        for (String option : options) {
            if (option.charAt(0) == '-') continue;
            taskUsage.append(' ');
            taskUsage.append(option);
        }
        taskUsage.append(NL);
        taskUsage.append(NL);
        taskUsage.append(ExeHelpAction.getHelpPart("global.description", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append(this.getDescription(task));
        taskUsage.append(NL);
        if (options.size() > 0) {
            taskUsage.append(NL);
            taskUsage.append(ExeHelpAction.getHelpPart("global.options", new Object[0]));
            for (String option : task.getCommandOptions()) {
                String optionKey;
                taskUsage.append(NL);
                try {
                    optionKey = ExeHelpAction.getHelpPart((Object)((Object)task) + ".option-key." + option, new Object[0]);
                }
                catch (MissingResourceException e) {
                    optionKey = "    " + option;
                }
                taskUsage.append(optionKey);
                taskUsage.append(NL);
                taskUsage.append(ExeHelpAction.getHelpPart((Object)((Object)task) + ".option-desc." + option, new Object[0]));
                taskUsage.append(NL);
            }
        }
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    private StringBuilder verboseHelp() {
        StringBuilder verboseHelp = new StringBuilder(this.getScriptUsage());
        verboseHelp.append(NL);
        verboseHelp.append(ExeHelpAction.getHelpPart("global.actions", new Object[0]));
        verboseHelp.append(NL);
        for (ExeAction action : ExeAction.values()) {
            verboseHelp.append(NL);
            verboseHelp.append("    ");
            verboseHelp.append(action.toString());
            verboseHelp.append(NL);
            verboseHelp.append(this.getDescription(action));
            verboseHelp.append(NL);
        }
        verboseHelp.append(NL);
        verboseHelp.append(ExeHelpAction.getHelpPart("global.options", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(ExeHelpAction.getHelpPart("global.options.statement", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(NL);
        return verboseHelp;
    }

    private String getDescription(ExeAction action) {
        return ExeHelpAction.getHelpPart((Object)((Object)action) + ".desc", new Object[0]);
    }

    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode retCode = ReturnCode.OK;
        String actionName = args.getAction();
        if (actionName == null) {
            stdout.println(this.getScriptUsage());
        } else if (args.getPositionalArguments().isEmpty()) {
            stdout.println(this.verboseHelp());
        } else {
            try {
                ExeAction task = ExeAction.valueOf((String)args.getPositionalArguments().get(0));
                stdout.println(this.getTaskUsage(task));
            }
            catch (IllegalArgumentException iae) {
                stderr.println();
                stderr.println(ExeHelpAction.getHelpPart("task.unknown", args.getPositionalArguments().get(0)));
                stdout.println(this.getScriptUsage());
                retCode = ReturnCode.BAD_ARGUMENT;
            }
        }
        return retCode;
    }

    public static String getHelpPart(String key, Object ... args) {
        String option;
        if (LICENSE_KEY_MAPPING.containsKey(key)) {
            option = MessageFormat.format(licenseOptions.getString(key = LICENSE_KEY_MAPPING.get(key)), new Object[0]);
            if (!option.isEmpty() && !Character.isWhitespace(option.charAt(0))) {
                option = "\t" + option.replaceAll("[\r\n]+", "$0\t");
            }
        } else {
            option = options.getString(key);
        }
        return args.length == 0 ? option : MessageFormat.format(option, args);
    }

    public static ResourceBundle getOptions() {
        return options;
    }

    static {
        LICENSE_KEY_MAPPING.put("install.option-desc.--acceptLicense", "helpAcceptLicense");
        LICENSE_KEY_MAPPING.put("install.option-desc.--viewLicenseAgreement", "helpAgreement");
        LICENSE_KEY_MAPPING.put("install.option-desc.--viewLicenseInfo", "helpInformation");
    }
}

