/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils;
import io.openliberty.checkpoint.spi.CheckpointHook;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimestampUtils {
    @Deprecated
    protected static final long startTime;
    @Deprecated
    protected static final long startTimeNano;
    private static volatile long internalStartTimeNano;
    static final long serialVersionUID = -6376003990066628287L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTimeToFile(File file, long timestamp) {
        FileWriter fstream;
        String stamp;
        block6: {
            if (file == null) {
                return;
            }
            stamp = Long.toString(timestamp);
            fstream = null;
            if (FileUtils.ensureDirExists(file.getParentFile())) break block6;
            TimestampUtils.tryToClose(fstream);
            return;
        }
        try {
            fstream = new FileWriter(file);
            fstream.write(stamp, 0, stamp.length());
        }
        catch (IOException iOException) {
            try {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"106", null, (Object[])new Object[]{file, timestamp});
            }
            catch (Throwable throwable) {
                TimestampUtils.tryToClose(fstream);
                throw throwable;
            }
            TimestampUtils.tryToClose(fstream);
        }
        TimestampUtils.tryToClose(fstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={FileNotFoundException.class, NumberFormatException.class})
    public static long readTimeFromFile(File file) {
        long timestamp = 0L;
        FileReader fstream = null;
        BufferedReader in = null;
        try {
            fstream = new FileReader(file);
            in = new BufferedReader(fstream, 32);
            timestamp = Long.parseLong(in.readLine());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", (String)"127", null, (Object[])new Object[]{file});
        }
        finally {
            if (!TimestampUtils.tryToClose(in)) {
                TimestampUtils.tryToClose(fstream);
            }
        }
        return timestamp;
    }

    public static void auditElapsedTime(TraceComponent callingTc, String msgKey) {
        if (callingTc.isAuditEnabled()) {
            Tr.audit((TraceComponent)callingTc, (String)msgKey, (Object[])new Object[]{TimestampUtils.getElapsedTime()});
        }
    }

    public static String getElapsedTime() {
        return TimestampUtils.getElapsedTimeNanos(internalStartTimeNano);
    }

    @Deprecated
    public static String getElapsedTime(long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    static String getElapsedTimeAsStringFromMilliInterval(long elapsedTime) {
        return String.format("%.3f", (double)elapsedTime / 1000.0);
    }

    public static String getElapsedTimeNanos(long startTime) {
        long endTime = System.nanoTime();
        long elapsedTime = (endTime - startTime) / 1000000L;
        return TimestampUtils.getElapsedTimeAsStringFromMilliInterval(elapsedTime);
    }

    @FFDCIgnore(value={IOException.class})
    private static boolean tryToClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final long getStartTimeNano() {
        return internalStartTimeNano;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        BundleContext bc;
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils", TimestampUtils.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        long start = OsgiPropertyUtils.getLong("kernel.launch.time", 0L);
        if (start == 0L) {
            start = System.nanoTime();
        }
        startTime = System.currentTimeMillis();
        startTimeNano = start;
        internalStartTimeNano = start;
        Bundle thisBundle = FrameworkUtil.getBundle(TimestampUtils.class);
        if (thisBundle != null && (bc = thisBundle.getBundleContext()) != null) {
            final WsLocationAdmin locServiceImpl = (WsLocationAdmin)bc.getService(bc.getServiceReference(WsLocationAdmin.class));
            bc.registerService(CheckpointHook.class, (Object)new CheckpointHook(){
                static final long serialVersionUID = -7680829173628278530L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @FFDCIgnore(value={NumberFormatException.class, IOException.class, IllegalArgumentException.class})
                public void restore() {
                    long restoreTime = 0L;
                    try {
                        WsResource restoreTimeResource = locServiceImpl.getServerWorkareaResource("checkpoint/restoreTime");
                        List<String> restoreStartTimeEnv = Files.readAllLines(restoreTimeResource.asFile().toPath());
                        System.out.println("restore time: " + restoreStartTimeEnv);
                        if (!restoreStartTimeEnv.isEmpty()) {
                            long startTimeInMillis = Long.parseLong(restoreStartTimeEnv.get(0));
                            long currentTime = System.currentTimeMillis();
                            System.out.println("current time: " + currentTime);
                            restoreTime = currentTime - startTimeInMillis;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    internalStartTimeNano = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(restoreTime);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.TimestampUtils$1", 1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            }, FrameworkUtil.asDictionary(Collections.singletonMap("service.ranking", -2147483647)));
        }
    }
}

