/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.compression.Snappy;
import java.util.function.Supplier;

public final class SnappyCompressor
implements Compressor {
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private State state = State.Init;

    private SnappyCompressor() {
    }

    public static Supplier<SnappyCompressor> newFactory() {
        return SnappyCompressor::new;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Buffer compress(Buffer in, BufferAllocator allocator) throws CompressionException {
        switch (1.$SwitchMap$io$netty5$handler$codec$compression$SnappyCompressor$State[this.state.ordinal()]) {
            case 1: {
                return allocator.allocate(0);
            }
            case 2: {
                throw new CompressionException("Compressor closed");
            }
        }
        out = allocator.allocate(256);
        try {
            block28: {
                block29: {
                    if (this.state == State.Init) {
                        this.state = State.Started;
                        out.writeBytes(SnappyCompressor.STREAM_START);
                    } else if (this.state != State.Started) {
                        throw new IllegalStateException();
                    }
                    dataLength = in.readableBytes();
                    if (dataLength <= 18) break block29;
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        lengthIdx = out.writerOffset() + 1;
                        if (dataLength < 18) {
                            slice = in.readSplit(dataLength);
                            try {
                                SnappyCompressor.writeUnencodedChunk(slice, out, dataLength);
                                break block28;
                            }
                            finally {
                                if (slice != null) {
                                    slice.close();
                                }
                            }
                        }
                        out.writeInt(0);
                        if (dataLength <= 32767) ** break;
                        slice = in.readSplit(32767);
                        try {
                            SnappyCompressor.calculateAndWriteChecksum(slice, out);
                            this.snappy.encode(slice, out, 32767);
                            SnappyCompressor.setChunkLength(out, lengthIdx);
                            dataLength -= 32767;
                        }
                        finally {
                            if (slice == null) continue;
                            slice.close();
                            continue;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    slice = in.readSplit(dataLength);
                    try {
                        SnappyCompressor.calculateAndWriteChecksum(slice, out);
                        this.snappy.encode(slice, out, dataLength);
                        SnappyCompressor.setChunkLength(out, lengthIdx);
                    }
                    finally {
                        if (slice != null) {
                            slice.close();
                        }
                    }
                }
                SnappyCompressor.writeUnencodedChunk(in, out, dataLength);
            }
            return out;
        }
        catch (Throwable cause) {
            out.close();
            throw cause;
        }
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case Closed: {
                throw new CompressionException("Compressor closed");
            }
            case Finished: 
            case Init: 
            case Started: {
                this.state = State.Finished;
                return allocator.allocate(0);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        switch (this.state) {
            case Finished: 
            case Closed: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.Closed;
    }

    @Override
    public void close() {
        this.state = State.Closed;
    }

    private static void writeUnencodedChunk(Buffer in, Buffer out, int dataLength) {
        out.writeByte((byte)1);
        SnappyCompressor.writeChunkLength(out, dataLength + 4);
        SnappyCompressor.calculateAndWriteChecksum(in, out);
        in.copyInto(in.readerOffset(), out, out.writerOffset(), dataLength);
        in.skipReadableBytes(dataLength);
        out.skipWritableBytes(dataLength);
    }

    private static void setChunkLength(Buffer out, int lengthIdx) {
        int chunkLength = out.writerOffset() - lengthIdx - 3;
        if (chunkLength >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + chunkLength);
        }
        out.setMedium(lengthIdx, BufferUtil.reverseMedium((int)chunkLength));
    }

    private static void writeChunkLength(Buffer out, int chunkLength) {
        out.writeMedium(BufferUtil.reverseMedium((int)chunkLength));
    }

    private static void calculateAndWriteChecksum(Buffer slice, Buffer out) {
        out.writeInt(Integer.reverseBytes(Snappy.calculateChecksum(slice)));
    }

    private static enum State {
        Init,
        Started,
        Finished,
        Closed;

    }
}

