/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.compression.BufferChecksum;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.compression.FastLz;
import java.util.function.Supplier;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public final class FastLzDecompressor
implements Decompressor {
    private State currentState = State.INIT_BLOCK;
    private final BufferChecksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    private FastLzDecompressor(Checksum checksum) {
        this.checksum = checksum == null ? null : new BufferChecksum(checksum);
    }

    public static Supplier<FastLzDecompressor> newFactory() {
        return FastLzDecompressor.newFactory(false);
    }

    public static Supplier<FastLzDecompressor> newFactory(boolean validateChecksums) {
        return FastLzDecompressor.newFactory(validateChecksums ? new Adler32() : null);
    }

    public static Supplier<FastLzDecompressor> newFactory(Checksum checksum) {
        return () -> new FastLzDecompressor(checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer decompress(Buffer in, BufferAllocator allocator) throws DecompressionException {
        switch (this.currentState) {
            case CLOSED: {
                throw new DecompressionException("Decompressor closed");
            }
            case DONE: 
            case CORRUPTED: {
                return allocator.allocate(0);
            }
            case INIT_BLOCK: {
                byte options;
                if (in.readableBytes() < 4) {
                    return null;
                }
                int magic = in.readUnsignedMedium();
                if (magic != 4607066) {
                    this.streamCorrupted("unexpected block identifier");
                }
                this.isCompressed = ((options = in.readByte()) & 1) == 1;
                this.hasChecksum = (options & 0x10) == 16;
                this.currentState = State.INIT_BLOCK_PARAMS;
            }
            case INIT_BLOCK_PARAMS: {
                if (in.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) {
                    return null;
                }
                this.currentChecksum = this.hasChecksum ? in.readInt() : 0;
                this.chunkLength = in.readUnsignedShort();
                this.originalLength = this.isCompressed ? in.readUnsignedShort() : this.chunkLength;
                this.currentState = State.DECOMPRESS_DATA;
            }
            case DECOMPRESS_DATA: {
                int chunkLength = this.chunkLength;
                if (in.readableBytes() < chunkLength) {
                    return null;
                }
                int idx = in.readerOffset();
                int originalLength = this.originalLength;
                try (Buffer output = null;){
                    Buffer data;
                    if (this.isCompressed) {
                        int outputOffset;
                        output = allocator.allocate(originalLength);
                        int decompressedBytes = FastLz.decompress(in, idx, chunkLength, output, outputOffset = output.writerOffset(), originalLength);
                        if (originalLength != decompressedBytes) {
                            this.streamCorrupted(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", originalLength, decompressedBytes));
                        }
                        output.skipWritableBytes(decompressedBytes);
                        in.skipReadableBytes(chunkLength);
                    } else {
                        output = in.readSplit(chunkLength);
                    }
                    BufferChecksum checksum = this.checksum;
                    if (this.hasChecksum && checksum != null) {
                        checksum.reset();
                        checksum.update(output, output.readerOffset(), output.readableBytes());
                        int checksumResult = (int)checksum.getValue();
                        if (checksumResult != this.currentChecksum) {
                            this.streamCorrupted(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", checksumResult, this.currentChecksum));
                        }
                    }
                    if (output.readableBytes() > 0) {
                        data = output;
                        output = null;
                    } else {
                        data = null;
                    }
                    this.currentState = State.INIT_BLOCK;
                    Buffer buffer = data;
                    return buffer;
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.currentState == State.DONE || this.currentState == State.CORRUPTED || this.currentState == State.CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.currentState == State.CLOSED;
    }

    @Override
    public void close() {
        this.currentState = State.CLOSED;
    }

    private void streamCorrupted(String message) {
        this.currentState = State.CORRUPTED;
        throw new DecompressionException(message);
    }

    private static enum State {
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        DECOMPRESS_DATA,
        DONE,
        CORRUPTED,
        CLOSED;

    }
}

