/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.compression.BufferChecksum;
import io.netty5.handler.codec.compression.DecompressionException;

final class CompressionUtil {
    private CompressionUtil() {
    }

    static void checkChecksum(BufferChecksum checksum, Buffer uncompressed, int currentChecksum) {
        checksum.reset();
        checksum.update(uncompressed, uncompressed.readerOffset(), uncompressed.readableBytes());
        int checksumResult = (int)checksum.getValue();
        if (checksumResult != currentChecksum) {
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", checksumResult, currentChecksum));
        }
    }
}

