/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class CompressionHandler
implements ChannelHandler {
    private final Supplier<? extends Compressor> compressorSupplier;
    private final long closeWriteTimeout;
    private final TimeUnit closeWriteTimeoutUnit;
    private final boolean discardBytesAfterFinished;
    private Compressor compressor;

    public CompressionHandler(Supplier<? extends Compressor> compressorSupplier) {
        this(compressorSupplier, 10L, TimeUnit.SECONDS, true);
    }

    public CompressionHandler(Supplier<? extends Compressor> compressorSupplier, long closeWriteTimeout, TimeUnit closeWriteTimeoutUnit, boolean discardBytesAfterFinished) {
        this.compressorSupplier = Objects.requireNonNull(compressorSupplier, "compressorSupplier");
        this.closeWriteTimeout = ObjectUtil.checkPositive((long)closeWriteTimeout, (String)"closeWriteTimeout");
        this.closeWriteTimeoutUnit = Objects.requireNonNull(closeWriteTimeoutUnit, "closeWriteTimeoutUnit");
        this.discardBytesAfterFinished = discardBytesAfterFinished;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.compressor = this.compressorSupplier.get();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            try {
                this.finish(ctx, false);
            }
            finally {
                this.closeCompressor();
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.closeCompressor();
        }
        ctx.fireChannelInactive();
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (this.compressor == null || !(msg instanceof Buffer)) {
            return ctx.write(msg);
        }
        Buffer input = (Buffer)msg;
        if (this.compressor.isFinished()) {
            if (this.discardBytesAfterFinished) {
                input.close();
                return ctx.newSucceededFuture();
            }
            return ctx.write(msg);
        }
        try (Buffer buffer = input;){
            Buffer buffer2 = this.compressor.compress(input, ctx.bufferAllocator());
            Future future = ctx.write((Object)buffer2);
            return future;
        }
    }

    public Future<Void> close(ChannelHandlerContext ctx) {
        return this.finish(ctx, true);
    }

    private Future<Void> finish(ChannelHandlerContext ctx, boolean closeCtx) {
        if (this.compressor == null || this.compressor.isFinished()) {
            return closeCtx ? ctx.close() : ctx.newSucceededFuture();
        }
        Buffer buffer = this.compressor.finish(ctx.bufferAllocator());
        if (buffer.readableBytes() == 0) {
            buffer.close();
            return closeCtx ? ctx.close() : ctx.newSucceededFuture();
        }
        if (closeCtx) {
            Promise promise = ctx.newPromise();
            Future f = ctx.writeAndFlush((Object)buffer).addListener((Object)ctx, (c, ignore) -> c.close().cascadeTo(promise));
            if (!f.isDone()) {
                Future sF = ctx.executor().schedule(() -> ctx.close().cascadeTo(promise), this.closeWriteTimeout, this.closeWriteTimeoutUnit);
                f.addListener((Object)sF, (scheduledFuture, ignore) -> scheduledFuture.cancel());
            }
            return promise.asFuture();
        }
        return ctx.write((Object)buffer);
    }

    private void closeCompressor() {
        this.compressor.close();
        this.compressor = null;
    }
}

