/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.DecoderException;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageDecoder<I>
extends ChannelHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageDecoder.class, (String)"I");
    }

    protected MessageToMessageDecoder(Class<? extends I> inboundMessageType) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (this.acceptInboundMessage(msg)) {
                Object cast = msg;
                this.decodeAndClose(ctx, cast);
            } else {
                ctx.fireChannelRead(msg);
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
    }

    protected void decode(ChannelHandlerContext ctx, I msg) throws Exception {
        throw new CodecException(((Object)((Object)this)).getClass().getName() + " must override either decode() or decodeAndClose().");
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, I msg) throws Exception {
        try (AutoCloseable ignore = SilentDispose.autoClosing(msg);){
            this.decode(ctx, msg);
        }
    }
}

