/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.util.internal.ObjectUtil;

public class FixedLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int frameLength;

    public FixedLengthFrameDecoder(int frameLength) {
        ObjectUtil.checkPositive((int)frameLength, (String)"frameLength");
        this.frameLength = frameLength;
    }

    public FixedLengthFrameDecoder(int frameLength, ByteToMessageDecoder.Cumulator cumulator) {
        super(cumulator);
        ObjectUtil.checkPositive((int)frameLength, (String)"frameLength");
        this.frameLength = frameLength;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Object decoded = this.decode0(ctx, in);
        if (decoded != null) {
            ctx.fireChannelRead(decoded);
        }
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer in) throws Exception {
        if (in.readableBytes() < this.frameLength) {
            return null;
        }
        return in.readSplit(this.frameLength);
    }
}

