/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import java.util.Objects;

public class DecoderResult {
    private static final DecoderResult SUCCESS = new DecoderResult();
    private final Throwable cause;

    public static DecoderResult failure(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        return new DecoderResult(cause);
    }

    public static DecoderResult success() {
        return SUCCESS;
    }

    protected DecoderResult(Throwable cause) {
        this.cause = Objects.requireNonNull(cause, "cause");
    }

    protected DecoderResult() {
        this.cause = null;
    }

    public final boolean isSuccess() {
        return this.cause == null;
    }

    public final boolean isFailure() {
        return this.cause != null;
    }

    public final Throwable cause() {
        return this.cause;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "success";
        }
        String cause = this.cause().toString();
        return new StringBuilder(cause.length() + 17).append("failure(").append(cause).append(')').toString();
    }
}

