/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.Socket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class LinuxSocketTest {
    @BeforeAll
    public static void loadJNI() {
        Epoll.ensureAvailability();
    }

    @Test
    public void testBindNonIpv6SocketToInet6AddressThrows() throws Exception {
        final LinuxSocket socket = LinuxSocket.newSocketStream((boolean)false);
        try {
            Assertions.assertThrows(IOException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    socket.bind((SocketAddress)new InetSocketAddress(InetAddress.getByAddress(new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49}), 0));
                }
            });
        }
        finally {
            socket.close();
        }
    }

    @Test
    public void testConnectNonIpv6SocketToInet6AddressThrows() throws Exception {
        final LinuxSocket socket = LinuxSocket.newSocketStream((boolean)false);
        try {
            Assertions.assertThrows(IOException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    socket.connect((SocketAddress)new InetSocketAddress(InetAddress.getByAddress(new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49}), 1234));
                }
            });
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnixDomainSocketTooLongPathFails() throws IOException {
        StringBuilder socketPath = new StringBuilder("/tmp/");
        while (socketPath.length() < 255) {
            socketPath.append(UUID.randomUUID());
        }
        final DomainSocketAddress domainSocketAddress = new DomainSocketAddress(socketPath.toString());
        final Socket socket = Socket.newSocketDomain();
        try {
            Exception exception = (Exception)Assertions.assertThrows(Errors.NativeIoException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    socket.bind((SocketAddress)domainSocketAddress);
                }
            });
            Assertions.assertTrue((boolean)exception.getMessage().contains("too long"));
        }
        finally {
            socket.close();
        }
    }
}

