/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class EpollTest {
    @Test
    public void testIsAvailable() {
        Assertions.assertTrue((boolean)Epoll.isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testEpollWaitWithTimeOutMinusOne() throws Exception {
        final EpollEventArray eventArray = new EpollEventArray(8);
        try {
            final FileDescriptor epoll = Native.newEpollCreate();
            FileDescriptor timerFd = Native.newTimerFd();
            final FileDescriptor eventfd = Native.newEventFd();
            Native.epollCtlAdd((int)epoll.intValue(), (int)timerFd.intValue(), (int)Native.EPOLLIN);
            Native.epollCtlAdd((int)epoll.intValue(), (int)eventfd.intValue(), (int)Native.EPOLLIN);
            final AtomicReference ref = new AtomicReference();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assertions.assertEquals((int)1, (int)Native.epollWait((FileDescriptor)epoll, (EpollEventArray)eventArray, (boolean)false));
                        Assertions.assertEquals((int)eventfd.intValue(), (int)eventArray.fd(0));
                    }
                    catch (Throwable cause) {
                        ref.set(cause);
                    }
                }
            });
            t.start();
            t.join(1000L);
            Assertions.assertTrue((boolean)t.isAlive());
            Native.eventFdWrite((int)eventfd.intValue(), (long)1L);
            t.join();
            Assertions.assertNull(ref.get());
            epoll.close();
            timerFd.close();
            eventfd.close();
        }
        finally {
            eventArray.free();
        }
    }
}

