/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.uptime.UptimeClient;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class UptimeClientHandler
extends SimpleChannelInboundHandler<Object> {
    long startTime = -1L;

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.println("Connected to: " + ctx.channel().remoteAddress());
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (!(evt instanceof IdleStateEvent)) {
            return;
        }
        IdleStateEvent e = (IdleStateEvent)evt;
        if (e.state() == IdleState.READER_IDLE) {
            this.println("Disconnecting due to no inbound traffic");
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.println("Disconnected from: " + ctx.channel().remoteAddress());
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.println("Sleeping for: " + UptimeClient.RECONNECT_DELAY + 's');
        final EventLoop loop = ctx.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                UptimeClientHandler.this.println("Reconnecting to: " + UptimeClient.HOST + ':' + UptimeClient.PORT);
                UptimeClient.connect(UptimeClient.configureBootstrap(new Bootstrap(), (EventLoopGroup)loop));
            }
        }, (long)UptimeClient.RECONNECT_DELAY, TimeUnit.SECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    void println(String msg) {
        if (this.startTime < 0L) {
            System.err.format("[SERVER IS DOWN] %s%n", msg);
        } else {
            System.err.format("[UPTIME: %5ds] %s%n", (System.currentTimeMillis() - this.startTime) / 1000L, msg);
        }
    }
}

