/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvousBytes;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.udt.nio.NioUdtProvider;

public class ByteEchoPeerHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBuf message;

    public ByteEchoPeerHandler(int messageSize) {
        super(false);
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        System.err.println("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void messageReceived(ChannelHandlerContext ctx, ByteBuf buf) {
        ctx.write((Object)buf);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

