/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvous;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;

public class MsgEchoPeerHandler
extends SimpleChannelInboundHandler<UdtMessage> {
    private final UdtMessage message;

    public MsgEchoPeerHandler(int messageSize) {
        super(false);
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        System.err.println("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void messageReceived(ChannelHandlerContext ctx, UdtMessage message) {
        ctx.write((Object)message);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

