/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.spdy.client.HttpResponseClientHandler;
import io.netty.example.spdy.client.SpdyClientInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.SpdyOrHttpChooser;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class SpdyClient {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", SSL ? "8443" : "8080"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SslContext sslCtx = SslContext.newClientContext(null, (TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{SpdyOrHttpChooser.SelectedProtocol.SPDY_3_1.protocolName(), SpdyOrHttpChooser.SelectedProtocol.HTTP_1_1.protocolName()}), (long)0L, (long)0L);
        HttpResponseClientHandler httpResponseHandler = new HttpResponseClientHandler();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.remoteAddress(HOST, PORT);
            b.handler((ChannelHandler)new SpdyClientInitializer(sslCtx, httpResponseHandler));
            Channel channel = b.connect().syncUninterruptibly().channel();
            System.out.println("Connected to " + HOST + ':' + PORT);
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "");
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (CharSequence)HOST);
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (CharSequence)HttpHeaderValues.GZIP);
            channel.writeAndFlush((Object)request).sync();
            httpResponseHandler.queue().take().sync();
            System.out.println("Finished SPDY HTTP GET");
            channel.close().syncUninterruptibly();
        }
        finally {
            if (workerGroup != null) {
                workerGroup.shutdownGracefully();
            }
        }
    }
}

