/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.proxy.HexDumpProxyFrontendHandler;
import io.netty.util.concurrent.GenericFutureListener;

public class HexDumpProxyBackendHandler
extends ChannelHandlerAdapter {
    private final Channel inboundChannel;

    public HexDumpProxyBackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
        this.inboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        HexDumpProxyFrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }
}

